/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openvpms.archetype.rules.doc.AbstractDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.jasper.JRXMLDocumentException;
import org.xml.sax.SAXParseException;

public class JRXMLDocumentHandler
extends AbstractDocumentHandler {
    public JRXMLDocumentHandler(ArchetypeService service) {
        super("document.other", service);
    }

    public boolean canHandle(String name, String mimeType) {
        return name.endsWith(".jrxml");
    }

    public boolean canHandle(String name, String archetype, String mimeType) {
        boolean result = super.canHandle(name, archetype, mimeType);
        return result && name.endsWith(".jrxml");
    }

    public Document create(String name, InputStream stream, String mimeType, int size) {
        Document document;
        JasperDesign design;
        try {
            design = JRXmlLoader.load((InputStream)stream);
        }
        catch (JRException exception) {
            if (ExceptionUtils.getRootCause((Throwable)exception) instanceof SAXParseException) {
                if (name == null) {
                    name = "file";
                }
                throw new JRXMLDocumentException(ReportMessages.failedToReadJasperReport(name), exception);
            }
            throw new DocumentException(DocumentException.ErrorCode.ReadError, (Throwable)exception, new Object[]{name});
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DeflaterOutputStream deflater = new DeflaterOutputStream(bytes);
            CountingOutputStream output = new CountingOutputStream((OutputStream)deflater);
            JRXmlWriter.writeReport((JRReport)design, (OutputStream)output, (String)"UTF-8");
            deflater.close();
            document = this.create(name, bytes.toByteArray(), "text/xml", output.getCount());
        }
        catch (Exception exception) {
            throw new DocumentException(DocumentException.ErrorCode.WriteError, (Throwable)exception, new Object[]{name});
        }
        return document;
    }
}

