/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import org.apache.commons.jxpath.Functions;
import org.openvpms.component.business.service.archetype.helper.ResolvingPropertySet;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.jasper.JDBCQueryExecuter;

public class JDBCQueryExecuterFactory
extends JRJdbcQueryExecuterFactory {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final Functions functions;
    private String reportName;
    private ResolvingPropertySet fields;

    public JDBCQueryExecuterFactory(ArchetypeService service, LookupService lookups, Functions functions) {
        this.service = service;
        this.lookups = lookups;
        this.functions = functions;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields != null ? new ResolvingPropertySet(fields, this.service, this.lookups) : null;
    }

    public JRQueryExecuter createQueryExecuter(JasperReportsContext context, JasperReport report, Map<String, Object> parameters) throws JRException {
        JRDataset dataset = report.getMainDataset();
        return this.createQueryExecuter(context, dataset, JDBCQueryExecuterFactory.convert(report, context, parameters));
    }

    public JRQueryExecuter createQueryExecuter(JasperReportsContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
        return new JDBCQueryExecuter(context, dataset, parameters, this.fields, this.reportName, this.service, this.lookups, this.functions);
    }

    private static Map<String, ? extends JRValueParameter> convert(JasperReport report, JasperReportsContext context, Map<String, Object> parameters) throws JRException {
        Map evaluated = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReportsContext)context, (JasperReport)report, parameters);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (evaluated.containsKey(entry.getKey())) continue;
            evaluated.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (JRParameter parameter : report.getParameters()) {
            String name = parameter.getName();
            if ("REPORT_PARAMETERS_MAP".equals(name)) {
                result.put(name, new Parameter(parameter, evaluated));
                continue;
            }
            result.put(name, new Parameter(parameter, evaluated.get(name)));
        }
        return result;
    }

    private static class Parameter
    implements JRValueParameter {
        private final JRParameter parameter;
        private Object value;

        public Parameter(JRParameter parameter, Object value) {
            this.parameter = parameter;
            this.value = value;
        }

        public boolean hasProperties() {
            return this.parameter.hasProperties();
        }

        public String getName() {
            return this.parameter.getName();
        }

        public String getDescription() {
            return this.parameter.getDescription();
        }

        public void setDescription(String description) {
            this.parameter.setDescription(description);
        }

        public Class<?> getValueClass() {
            return this.parameter.getValueClass();
        }

        public String getValueClassName() {
            return this.parameter.getValueClassName();
        }

        public boolean isSystemDefined() {
            return this.parameter.isSystemDefined();
        }

        public boolean isForPrompting() {
            return this.parameter.isForPrompting();
        }

        public JRExpression getDefaultValueExpression() {
            return this.parameter.getDefaultValueExpression();
        }

        public Class<?> getNestedType() {
            return this.parameter.getNestedType();
        }

        public String getNestedTypeName() {
            return this.parameter.getNestedTypeName();
        }

        public JRPropertiesMap getPropertiesMap() {
            return this.parameter.getPropertiesMap();
        }

        public JRPropertiesHolder getParentProperties() {
            return this.parameter.getParentProperties();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ParameterEvaluationTimeEnum getEvaluationTime() {
            return this.parameter.getEvaluationTime();
        }

        public Object clone() {
            throw new JRRuntimeException("Clone not supported");
        }
    }
}

