/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.commons.collections4.comparators.TransformingComparator;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.BasePropertyResolver;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.sort.IMObjectSorter;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IMObjectResolver
extends BasePropertyResolver {
    private final IMObject root;
    private static final Comparator<Object> DEFAULT_COMPARATOR = ComparatorUtils.nullLowComparator(null);
    private static final Logger log = LoggerFactory.getLogger(IMObjectResolver.class);

    public IMObjectResolver(IMObject root, ArchetypeService service, LookupService lookups) {
        super(service, lookups);
        this.root = root;
    }

    public Object getObject(String name) {
        return new NodeResolver(this.root, this.getService(), this.getLookups()).getObject(name);
    }

    public List<Object> getObjects(String name) {
        return new NodeResolver(this.root, this.getService(), this.getLookups()).getObjects(name);
    }

    public PropertyState resolve(String name) {
        return new NodeResolver(this.root, this.getService(), this.getLookups()).resolve(name);
    }

    public List<IMObject> getObjects(String name, boolean relativeToRoot, String ... sortNodes) {
        List<IMObject> result = sortNodes.length == 0 || !relativeToRoot ? this.getObjectsAndSortRelativeToLeaf(name, sortNodes) : this.getObjectsAndSortRelativeToRoot(name, sortNodes);
        return result;
    }

    private List<IMObject> getObjectsAndSortRelativeToLeaf(String name, String ... sortNodes) {
        List<Object> result = this.getObjects(name);
        ComparatorChain chain = new ComparatorChain();
        for (String sortNode : sortNodes) {
            RelativeNodeTransformer transformer = new RelativeNodeTransformer(sortNode);
            TransformingComparator transComparator = new TransformingComparator((Transformer)transformer, DEFAULT_COMPARATOR);
            chain.addComparator((Comparator)transComparator);
        }
        chain.addComparator(IMObjectSorter.getIdComparator());
        result.sort((Comparator<Object>)chain);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<IMObject> getObjectsAndSortRelativeToRoot(String name, String[] sortNodes) {
        void var10_16;
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        List<NodeObject> leafNodes = new ArrayList<NodeObject>();
        leafNodes.add(new NodeObject(null, this.root));
        String[] nodes = StringUtils.split((String)name, (char)'.');
        if (nodes.length == 0) {
            throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, new Object[]{name});
        }
        for (String node : nodes) {
            leafNodes = this.getChildNodes(leafNodes, node, name);
        }
        ArrayList<List<IMObject>> lists = new ArrayList<List<IMObject>>();
        for (NodeObject object : leafNodes) {
            lists.add(object.getPathAfter(this.root));
        }
        ComparatorChain chain = new ComparatorChain();
        String[] object = sortNodes;
        int n = object.length;
        boolean bl = false;
        while (var10_16 < n) {
            String sortNode = object[var10_16];
            Comparator<List<IMObject>> comparator = this.getListNodeComparator(nodes, sortNode);
            if (comparator != null) {
                chain.addComparator(comparator);
            }
            ++var10_16;
        }
        Transformer transformer = objects -> ((IMObject)objects.get(objects.size() - 1)).getId();
        chain.addComparator((Comparator)new TransformingComparator(transformer));
        lists.sort((Comparator<List<IMObject>>)chain);
        for (List list : lists) {
            result.add((IMObject)list.get(list.size() - 1));
        }
        return result;
    }

    private Comparator<List<IMObject>> getListNodeComparator(String[] nodes, String sortNode) {
        ListNodeComparator result = null;
        Object[] sortNodes = StringUtils.split((String)sortNode, (char)'.');
        int lastMatch = -1;
        int i = 0;
        while (i < nodes.length && i < sortNodes.length && nodes[i].equals(sortNodes[i])) {
            lastMatch = i++;
        }
        if (lastMatch >= 0 && lastMatch + 1 < sortNodes.length) {
            String relativeSortNode = StringUtils.join((Object[])sortNodes, (char)'.', (int)(lastMatch + 1), (int)sortNodes.length);
            result = new ListNodeComparator(lastMatch, relativeSortNode);
        } else {
            log.warn("Invalid absolute sort node: {} given for node: {}", (Object)sortNode, (Object)StringUtils.join((Object[])nodes, (char)'.'));
        }
        return result;
    }

    private List<NodeObject> getChildNodes(List<NodeObject> parents, String node, String name) {
        ArrayList<NodeObject> result = new ArrayList<NodeObject>();
        ArchetypeDescriptor archetype = null;
        for (NodeObject parent : parents) {
            IMObject object = parent.object;
            archetype = this.getArchetype(object, archetype);
            for (IMObject child : this.getChildren(object, node, name, archetype)) {
                result.add(parent.addChild(child));
            }
        }
        return result;
    }

    private List<IMObject> getChildren(IMObject parent, String node, String name, ArchetypeDescriptor archetype) {
        List<IMObject> result = Collections.emptyList();
        NodeDescriptor descriptor = this.getNode(archetype, node);
        if (descriptor.isCollection()) {
            result = descriptor.getValues(parent);
        } else {
            Object child = this.getValue(parent, descriptor, true);
            if (child != null) {
                if (child instanceof IMObject) {
                    result = Collections.singletonList((IMObject)child);
                } else {
                    throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, new Object[]{name});
                }
            }
        }
        return result;
    }

    private Comparable<Object> getComparable(IMObject object, String node) {
        Object result = null;
        try {
            NodeResolver resolver = new NodeResolver(object, this.getService(), this.getLookups());
            result = resolver.getObject(node);
        }
        catch (PropertyResolverException propertyResolverException) {
            // empty catch block
        }
        return result instanceof Comparable ? (Comparable)result : null;
    }

    private static class NodeObject {
        private final NodeObject parent;
        private final IMObject object;

        public NodeObject(NodeObject parent, IMObject object) {
            this.parent = parent;
            this.object = object;
        }

        public NodeObject addChild(IMObject object) {
            return new NodeObject(this, object);
        }

        public List<IMObject> getPathAfter(IMObject root) {
            ArrayList<IMObject> result = new ArrayList<IMObject>();
            NodeObject node = this;
            while (node != null && node.object != root) {
                result.add(node.object);
                node = node.parent;
            }
            Collections.reverse(result);
            return result;
        }
    }

    private class ListNodeComparator
    implements Comparator<List<IMObject>> {
        private final int index;
        private final String sortNode;

        public ListNodeComparator(int index, String sortNode) {
            this.index = index;
            this.sortNode = sortNode;
        }

        @Override
        public int compare(List<IMObject> o1, List<IMObject> o2) {
            int result = 0;
            if (this.index < o1.size() && this.index < o2.size()) {
                Comparable v1 = IMObjectResolver.this.getComparable(o1.get(this.index), this.sortNode);
                Comparable v2 = IMObjectResolver.this.getComparable(o2.get(this.index), this.sortNode);
                result = DEFAULT_COMPARATOR.compare(v1, v2);
            }
            return result;
        }
    }

    private class RelativeNodeTransformer
    implements Transformer<IMObject, Comparable<Object>> {
        private final String name;

        public RelativeNodeTransformer(String name) {
            this.name = name;
        }

        public Comparable<Object> transform(IMObject input) {
            return IMObjectResolver.this.getComparable(input, this.name);
        }
    }
}

