/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.report.Parameters;
import org.openvpms.report.jasper.AbstractDataSource;
import org.openvpms.report.jasper.IMObjectDataSource;
import org.openvpms.report.jasper.ReportContext;

public class IMObjectCollectionDataSource
extends AbstractDataSource
implements JRRewindableDataSource {
    private final Iterable<IMObject> collection;
    private Iterator<IMObject> iterator;
    private IMObjectDataSource current;

    public IMObjectCollectionDataSource(Iterable<IMObject> objects, Parameters parameters, PropertySet fields, String reportName, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions) {
        this(objects, new ReportContext(parameters, fields, reportName, service, lookups, handlers, functions));
    }

    public IMObjectCollectionDataSource(Iterable<IMObject> objects, ReportContext context) {
        super(context);
        this.collection = objects;
        this.iterator = this.collection.iterator();
    }

    protected IMObjectCollectionDataSource(List<IMObject> values, ReportContext context) {
        super(context);
        this.collection = values;
        this.iterator = this.collection.iterator();
    }

    public boolean next() {
        boolean result = this.iterator.hasNext();
        if (result) {
            this.current = new IMObjectDataSource(this.iterator.next(), this.getContext());
        }
        return result;
    }

    @Override
    public JRRewindableDataSource getDataSource(String name, boolean relativeToRoot, String ... sortNodes) throws JRException {
        return this.current.getDataSource(name, relativeToRoot, sortNodes);
    }

    @Override
    public JRRewindableDataSource getExpressionDataSource(String expression) throws JRException {
        return this.current.getExpressionDataSource(expression);
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getValue(field);
    }

    @Override
    public Object evaluate(String expression) {
        return this.current != null ? this.current.evaluate(expression) : null;
    }

    @Override
    public Object evaluate(Object object, String expression) {
        return this.current != null ? this.current.evaluate(object, expression) : null;
    }

    public void moveFirst() {
        this.iterator = this.collection.iterator();
    }

    @Override
    protected Object getValue(JRField field) throws JRException {
        return this.current != null ? this.current.getFieldValue(field) : null;
    }
}

