/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.sql.Connection;
import java.util.Collections;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.repo.RepositoryService;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.ParameterType;
import org.openvpms.report.jasper.AbstractJasperIMReport;
import org.openvpms.report.jasper.JasperTemplateLoader;

public abstract class AbstractTemplatedJasperIMReport<T>
extends AbstractJasperIMReport<T> {
    private final String name;
    private final JasperTemplateLoader loader;

    public AbstractTemplatedJasperIMReport(String name, Document document, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions, Settings settings) {
        super(service, lookups, handlers, functions, settings);
        SimpleJasperReportsContext context = this.getJasperReportsContext();
        this.loader = this.init(new JasperTemplateLoader(document, service, handlers, (JasperReportsContext)context), context);
        this.name = name;
    }

    @Override
    public Set<ParameterType> getParameterTypes() {
        Set<ParameterType> result = super.getParameterTypes();
        JRQuery query = this.getReport().getQuery();
        if (query != null && "sql".equalsIgnoreCase(query.getLanguage())) {
            ParameterType type = new ParameterType("REPORT_CONNECTION", Connection.class, "JDBC connection", true);
            result.add(type);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canPrint() {
        return true;
    }

    @Override
    public JasperReport getReport() {
        return this.loader.getReport();
    }

    @Override
    protected JREvaluator getEvaluator() throws JRException {
        return this.loader.getEvaluator();
    }

    protected JasperTemplateLoader getLoader() {
        return this.loader;
    }

    private JasperTemplateLoader init(JasperTemplateLoader loader, SimpleJasperReportsContext context) {
        context.setExtensions(RepositoryService.class, Collections.singletonList(loader));
        return loader;
    }
}

