/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.report.ExpressionEvaluator;
import org.openvpms.report.jasper.DataSource;
import org.openvpms.report.jasper.IMObjectCollectionDataSource;
import org.openvpms.report.jasper.ReportContext;
import org.openvpms.report.util.ProtectedExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSource
implements DataSource {
    private final ReportContext context;
    private final ProtectedExpressionEvaluator expressionEvaluator;
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSource.class);

    public AbstractDataSource(ReportContext context) {
        this.context = context;
        this.expressionEvaluator = new ProtectedExpressionEvaluator(context.getReportName(), log);
    }

    @Override
    public JRRewindableDataSource getDataSource(String name) throws JRException {
        return this.getDataSource(name, false, new String[0]);
    }

    @Override
    public JRRewindableDataSource getDataSource(String name, String ... sortNodes) throws JRException {
        return this.getDataSource(name, false, sortNodes);
    }

    protected Object getFieldValue(JRField field, IMObject current) throws JRException {
        Object value;
        block4: {
            value = null;
            try {
                value = this.getValue(field);
                if (value == null || field.getValueClass().isInstance(value)) break block4;
                if (field.getValueClass() == String.class) {
                    value = value.toString();
                    break block4;
                }
                throw new JRException("Failed to evaluate '" + field.getName() + "' in report=" + this.getReportName() + ". Expected class=" + field.getValueClass() + " but got " + value.getClass().getName());
            }
            catch (JRException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                if (!log.isDebugEnabled()) break block4;
                this.expressionEvaluator.log(field.getName(), current, null, exception);
            }
        }
        return value;
    }

    protected abstract Object getValue(JRField var1) throws JRException;

    protected Object evaluate(String expression, ExpressionEvaluator evaluator, IMObject current) {
        return this.expressionEvaluator.evaluate(expression, evaluator, current);
    }

    protected Object evaluate(Object object, String expression, ExpressionEvaluator evaluator, IMObject current) {
        return this.expressionEvaluator.evaluate(object, expression, evaluator, current);
    }

    protected JRRewindableDataSource getExpressionDataSource(Object object, String expression) throws JRException {
        Object value = this.evaluate(object, expression);
        return this.getCollectionDataSource(value, expression);
    }

    protected JRRewindableDataSource getCollectionDataSource(Object value, String expression) throws JRException {
        List<IMObject> iterable;
        if (value instanceof Iterable) {
            iterable = (List<IMObject>)value;
        } else if (value instanceof IMObject) {
            iterable = Collections.singletonList((IMObject)value);
        } else {
            throw new JRException("Unsupported value type=" + (value != null ? value.getClass() : null) + " returned by expression=" + expression);
        }
        return new IMObjectCollectionDataSource((Iterable<IMObject>)iterable, this.context);
    }

    protected ReportContext getContext() {
        return this.context;
    }

    protected String getReportName() {
        return this.context.getReportName();
    }
}

