/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.i18n;

import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;

public class ReportMessages {
    private static final Messages messages = new Messages("REPORT", ReportMessages.class);

    private ReportMessages() {
    }

    public static Message failedToGenerateReport(String name, String reason) {
        return messages.create(1, new Object[]{name, reason});
    }

    public static Message failedToPrintReport(String name, String printer, String reason) {
        return messages.create(2, new Object[]{name, printer, reason});
    }

    public static Message cannotConvertJasperReport(String name, String mimeType) {
        return messages.create(10, new Object[]{name, mimeType});
    }

    public static Message failedToGetParameters(String name, String reason) {
        return messages.create(11, new Object[]{name, reason});
    }

    public static Message noPagesToPrint(String name) {
        return messages.create(12, new Object[]{name});
    }

    public static Message maxPagesExceeded(String name, int maxPages) {
        return messages.create(13, new Object[]{name, maxPages});
    }

    public static Message reportResourceNotFound(String name, String resource) {
        return messages.create(14, new Object[]{name, resource});
    }

    public static Message printerNotFound(String printer) {
        return messages.create(15, new Object[]{printer});
    }

    public static Message failedToCreateReport(String name, String reason) {
        return messages.create(20, new Object[]{name, reason});
    }

    public static Message failedToFindSubReport(String name, String parent) {
        return messages.create(21, new Object[]{name, parent});
    }

    public static Message noTemplateForType(String type) {
        return messages.create(30, new Object[]{type});
    }

    public static Message unsupportedTemplate(String name) {
        return messages.create(31, new Object[]{name});
    }

    public static Message templateHasNoDocument(String name) {
        return messages.create(32, new Object[]{name});
    }

    public static Message failedToReadJasperReport(String name) {
        return messages.create(40, new Object[]{name});
    }

    public static Message noExpressionEvaluatorForType(Class<?> type) {
        return messages.create(50, new Object[]{type.getName()});
    }

    public static Message failedToLoadOpenOfficeDocument(String name) {
        return messages.create(60, new Object[]{name});
    }

    public static Message failedToGetOpenOfficeUserFields(String name) {
        return messages.create(61, new Object[]{name});
    }

    public static Message failedToGetOpenOfficeField(String fieldName, String documentName) {
        return messages.create(62, new Object[]{fieldName, documentName});
    }

    public static Message failedToGetOpenOfficeInputFields(String name) {
        return messages.create(63, new Object[]{name});
    }

    public static Message failedToSetOpenOfficeField(String fieldName, String documentName) {
        return messages.create(64, new Object[]{fieldName, documentName});
    }

    public static Message failedToPrintOpenOfficeDocument(String name) {
        return messages.create(65, new Object[]{name});
    }

    public static Message failedToExportOpenOfficeDocument(String name) {
        return messages.create(66, new Object[]{name});
    }

    public static Message unsupportedConversion(String name, String mimeType, String toMimeType) {
        return messages.create(70, new Object[]{name, mimeType, toMimeType});
    }

    public static Message conversionFailed(String name, String mimeType) {
        return messages.create(71, new Object[]{name, mimeType});
    }

    public static Message failedToConnectToOpenOffice(String reason) {
        return messages.create(80, new Object[]{reason});
    }

    public static Message openOfficeError() {
        return messages.create(81, new Object[0]);
    }

    public static Message openOfficeTaskInterrupted() {
        return messages.create(82, new Object[0]);
    }

    public static Message openOfficeTaskCancelled() {
        return messages.create(83, new Object[0]);
    }

    public static Message openOfficeTaskTimedOut() {
        return messages.create(84, new Object[0]);
    }

    public static Message noDocument(String name) {
        return messages.create(100, new Object[]{name});
    }
}

