/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2022 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.report.msword;

import org.apache.commons.jxpath.Functions;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.openoffice.OpenOfficeDocument;
import org.openvpms.report.openoffice.OpenOfficeException;
import org.openvpms.report.openoffice.OpenOfficeIMReport;
import org.openvpms.report.openoffice.OpenOfficeService;


/**
 * Generates a report using an MS Word document as the template.
 *
 * @author Tim Anderson
 */
public class MsWordIMReport<T> extends OpenOfficeIMReport<T> {

    /**
     * Constructs an {@link MsWordIMReport}.
     *
     * @param template      the document template
     * @param service       the archetype service
     * @param lookups       the lookup service
     * @param handlers      the document handlers
     * @param functions     the JXPath extension functions
     * @param officeService the OpenOffice service
     */
    public MsWordIMReport(Document template, ArchetypeService service, LookupService lookups,
                          DocumentHandlers handlers, Functions functions, OpenOfficeService officeService) {
        super(template, service, lookups, handlers, functions, officeService);
    }

    /**
     * Creates a new document.
     *
     * @param template the document template
     * @param context  the OpenOffice context
     * @param handlers the document handlers
     * @return a new document
     * @throws OpenOfficeException for any error
     */
    @Override
    protected OpenOfficeDocument createDocument(Document template, LocalOfficeContext context,
                                                DocumentHandlers handlers) {
        return new MsWordDocument(template, context, handlers);
    }

}
