/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.report.tools.BaseTemplate;
import org.openvpms.report.tools.EmailTemplate;
import org.openvpms.report.tools.Template;
import org.openvpms.report.tools.Templates;
import org.openvpms.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TemplateLoader {
    private final IArchetypeService service;
    private final DocumentHandlers handlers;
    private final PlatformTransactionManager transactionManager;
    private final LookupService lookups;
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";
    private static final Logger log = LoggerFactory.getLogger(TemplateLoader.class);

    public TemplateLoader(IArchetypeService service, DocumentHandlers handlers, PlatformTransactionManager transactionManager, LookupService lookups) {
        this.service = service;
        this.handlers = handlers;
        this.transactionManager = transactionManager;
        this.lookups = lookups;
    }

    public void load(String path) throws JAXBException {
        this.load(path, new HashMap<String, Entity>());
    }

    public void load(String path, Map<String, Entity> emailTemplates) throws JAXBException {
        File file = new File(path);
        Templates templates = this.getTemplates(file);
        File dir = file.getParentFile();
        for (BaseTemplate template : templates.getTemplateOrEmailTemplate()) {
            if (!(template instanceof EmailTemplate)) continue;
            Entity entity = this.loadEmailTemplate((EmailTemplate)template, dir);
            emailTemplates.put(entity.getName(), entity);
        }
        for (BaseTemplate template : templates.getTemplateOrEmailTemplate()) {
            if (!(template instanceof Template)) continue;
            this.loadTemplate((Template)template, dir, emailTemplates);
        }
    }

    public boolean load(String name, Templates templates, File dir, Map<String, Entity> emailTemplates) {
        boolean found = false;
        for (BaseTemplate template : templates.getTemplateOrEmailTemplate()) {
            if (!template.getName().equals(name)) continue;
            if (template instanceof EmailTemplate) {
                Entity emailTemplate = this.loadEmailTemplate((EmailTemplate)template, dir);
                emailTemplates.put(template.getName(), emailTemplate);
            } else {
                this.loadTemplate((Template)template, dir, emailTemplates);
            }
            found = true;
            break;
        }
        return found;
    }

    public Templates getTemplates(File file) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Templates.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (Templates)unmarshaller.unmarshal(file);
    }

    public static void main(String[] args) {
        try {
            JSAP parser = TemplateLoader.createParser();
            JSAPResult config = parser.parse(args);
            if (!config.success()) {
                TemplateLoader.displayUsage(parser);
            } else {
                String contextPath = config.getString("context");
                String file = config.getString("file");
                Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                if (file != null) {
                    IArchetypeService service = (IArchetypeService)context.getBean(IArchetypeRuleService.class);
                    DocumentHandlers handlers = (DocumentHandlers)context.getBean(DocumentHandlers.class);
                    PlatformTransactionManager transactionManager = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
                    LookupService lookups = (LookupService)context.getBean(LookupService.class);
                    TemplateLoader loader = new TemplateLoader(service, handlers, transactionManager, lookups);
                    loader.load(file);
                } else {
                    TemplateLoader.displayUsage(parser);
                }
            }
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
    }

    private void loadTemplate(Template template, File dir, Map<String, Entity> emailTemplates) {
        DocLoader loader = new DocLoader(emailTemplates);
        loader.load(template, dir);
    }

    private Entity loadEmailTemplate(EmailTemplate template, File dir) {
        EmailLoader loader = new EmailLoader(template.isSystem());
        return loader.load(template, dir);
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("context").setShortFlag('c').setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        parser.registerParameter(new FlaggedOption("file").setShortFlag('f').setLongFlag("file").setHelp("The template configuration file to load."));
        return parser;
    }

    private static void displayUsage(JSAP parser) {
        System.err.println();
        System.err.println("Usage: java " + TemplateLoader.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private class EmailLoader
    extends Loader<EmailTemplate> {
        public EmailLoader(boolean useSystem) {
            super(useSystem ? "entity.documentTemplateEmailSystem" : "entity.documentTemplateEmailUser");
        }

        @Override
        protected Entity prepare(EmailTemplate template, File dir) {
            Entity entity = super.prepare(template, dir);
            IMObjectBean bean = TemplateLoader.this.service.getBean((IMObject)entity);
            bean.setValue("subject", (Object)template.getSubject());
            bean.setValue("subjectType", (Object)template.getSubjectType());
            bean.setValue("subjectSource", (Object)template.getSubjectSource());
            bean.setValue("contentType", (Object)"DOCUMENT");
            bean.setValue("contentSource", (Object)template.getContentSource());
            bean.setValue("defaultEmailAddress", (Object)template.getDefaultEmailAddress());
            return entity;
        }
    }

    private class DocLoader
    extends Loader<Template> {
        private final Map<String, Entity> emailTemplates;

        public DocLoader(Map<String, Entity> emailTemplates) {
            super("entity.documentTemplate");
            this.emailTemplates = emailTemplates;
        }

        @Override
        protected Entity prepare(Template template, File dir) {
            Template.EmailTemplate email;
            Entity entity = super.prepare(template, dir);
            IMObjectBean bean = TemplateLoader.this.service.getBean((IMObject)entity);
            Lookup type = TemplateLoader.this.lookups.getLookup("lookup.documentTemplateType", template.getArchetype());
            if (type == null) {
                throw new IllegalStateException("Template '" + template.getName() + "' references non-existent document template type: " + template.getArchetype());
            }
            Lookup existing = (Lookup)bean.getObject("type", Lookup.class);
            if (existing == null) {
                entity.addClassification(type);
            } else if (!existing.equals(type)) {
                entity.removeClassification(existing);
                entity.addClassification(type);
            }
            bean.setValue("reportType", (Object)template.getReportType());
            if (template.getOrientation() != null) {
                bean.setValue("orientation", (Object)template.getOrientation().value());
            }
            if ((email = template.getEmailTemplate()) != null) {
                Entity emailTemplate = this.emailTemplates.get(email.getName());
                if (emailTemplate == null) {
                    throw new IllegalStateException("Template '" + template.getName() + "' references non-existent email template: " + email.getName());
                }
                bean.setTarget("email", (IMObject)emailTemplate);
            }
            return entity;
        }
    }

    private abstract class Loader<T extends BaseTemplate> {
        private final String archetype;
        private Entity entity;
        private final Set<IMObject> toSave = new HashSet<IMObject>();

        public Loader(String archetype) {
            this.archetype = archetype;
        }

        public Entity load(T template, File dir) {
            TransactionTemplate txnTemplate = new TransactionTemplate(TemplateLoader.this.transactionManager);
            Entity entity = (Entity)txnTemplate.execute(status -> {
                Entity result = this.prepare(template, dir);
                TemplateLoader.this.service.save(this.toSave);
                return result;
            });
            log.info("Loaded '" + entity.getName() + "'");
            return entity;
        }

        protected Entity prepare(T template, File dir) {
            IMObjectBean bean;
            Document document = this.getDocument(dir, ((BaseTemplate)template).getPath(), ((BaseTemplate)template).getDocType(), ((BaseTemplate)template).getMimeType());
            DocumentAct act = this.getAct(document.getName());
            boolean updateDocument = true;
            Document existing = null;
            if (act != null) {
                bean = TemplateLoader.this.service.getBean((IMObject)act);
                this.entity = (Entity)bean.getTarget("template", Entity.class);
                Document document2 = existing = act.getDocument() != null ? (Document)TemplateLoader.this.service.get(act.getDocument()) : null;
                if (existing != null && existing.getSize() == document.getSize() && existing.getChecksum() == document.getChecksum() && Objects.equals(existing.getName(), document.getName()) && Objects.equals(existing.getMimeType(), document.getMimeType())) {
                    updateDocument = false;
                }
            } else {
                act = (DocumentAct)TemplateLoader.this.service.create("act.documentTemplate", DocumentAct.class);
            }
            if (updateDocument) {
                act.setFileName(document.getName());
                act.setMimeType(document.getMimeType());
                act.setDescription(DescriptorHelper.getDisplayName((IMObject)document, (ArchetypeService)TemplateLoader.this.service));
                this.toSave.add((IMObject)act);
                this.toSave.add((IMObject)document);
            } else {
                document = null;
            }
            if (this.entity == null) {
                this.entity = (Entity)TemplateLoader.this.service.create(this.archetype);
                if (this.entity == null) {
                    throw new IllegalStateException("Failed to create " + this.archetype + ": archetype not found");
                }
                bean = TemplateLoader.this.service.getBean((IMObject)act);
                bean.setTarget("template", (IMObject)this.entity);
                this.toSave.add((IMObject)act);
            }
            if (updateDocument) {
                if (!act.isNew() && existing != null) {
                    act.setDocument(null);
                    TemplateLoader.this.service.save((IMObject)act);
                    TemplateLoader.this.service.remove((IMObject)existing);
                }
                act.setDocument((Reference)document.getObjectReference());
            }
            this.entity.setName(((BaseTemplate)template).getName());
            this.entity.setDescription(((BaseTemplate)template).getDescription());
            bean = TemplateLoader.this.service.getBean((IMObject)this.entity);
            bean.setValue("revision", (Object)Version.VERSION);
            this.toSave.add((IMObject)this.entity);
            return this.entity;
        }

        protected Document getDocument(File dir, String path, String docType, String mimeType) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(dir, path);
            }
            if (docType == null) {
                docType = "document.other";
            }
            return DocumentHelper.create((File)file, (String)docType, (String)mimeType, (DocumentHandlers)TemplateLoader.this.handlers);
        }

        private DocumentAct getAct(String name) {
            ArchetypeQuery query = new ArchetypeQuery("act.documentTemplate", false, true);
            query.add((IConstraint)Constraints.eq((String)"name", (Object)name));
            query.add((IConstraint)Constraints.join((String)"template").add((IConstraint)Constraints.isA((String)"entity", (String[])new String[]{this.archetype})));
            query.add((IConstraint)Constraints.sort((String)"id"));
            query.setFirstResult(0);
            IMObjectQueryIterator iterator = new IMObjectQueryIterator(TemplateLoader.this.service, (IArchetypeQuery)query);
            return iterator.hasNext() ? (DocumentAct)iterator.next() : null;
        }
    }
}

