/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice.print;

import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeDocument;
import org.openvpms.report.openoffice.OpenOfficeException;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.report.openoffice.OpenOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficePrintService {
    private final OpenOfficeService officeService;
    private final DocumentHandlers handlers;
    private static final Logger log = LoggerFactory.getLogger(OpenOfficePrintService.class);

    public OpenOfficePrintService(OpenOfficeService officeService, DocumentHandlers handlers) {
        this.officeService = officeService;
        this.handlers = handlers;
    }

    public void print(Document document, PrintProperties properties) {
        PrintTask task = new PrintTask(document, properties);
        try {
            task.run(this.officeService);
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new OpenOfficeException(ReportMessages.failedToPrintOpenOfficeDocument(document.getName()), exception);
        }
    }

    private class PrintTask
    extends OpenOfficeTask<Void> {
        private final Document document;
        private final PrintProperties properties;

        public PrintTask(Document document, PrintProperties properties) {
            super(log.isDebugEnabled());
            this.document = document;
            this.properties = properties;
        }

        @Override
        protected Void run(LocalOfficeContext context) {
            try (OpenOfficeDocument doc = new OpenOfficeDocument(this.document, context, OpenOfficePrintService.this.handlers);){
                doc.print(this.properties);
            }
            return null;
        }

        @Override
        protected void start() {
            log.debug("Printing document='{}', id={}", (Object)this.document.getName(), (Object)this.document.getId());
        }

        @Override
        protected void stop(Exception exception, long delay, long elapsed) {
            if (exception != null) {
                log.debug("Failed to print document='{}', id={}, delay={}, elapsed={}: {}", new Object[]{this.document.getName(), this.document.getId(), this.duration(delay), this.duration(elapsed), exception.getMessage(), exception});
            } else {
                log.debug("Printed document='{}', id={}, delay={}, elapsed={}", new Object[]{this.document.getName(), this.document.getId(), this.duration(delay), this.duration(elapsed)});
            }
        }
    }
}

