/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import com.sun.star.awt.Point;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToByteArrayAdapter;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XRefreshable;
import com.sun.star.view.XPrintable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.print.attribute.standard.Sides;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.report.ParameterType;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeDocumentException;
import org.openvpms.report.openoffice.OpenOfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeDocument
implements AutoCloseable {
    private final String name;
    private final String debug;
    private final XComponent document;
    private final DocumentHandlers handlers;
    private Map<String, Field> userFields;
    private Map<String, Field> inputFields;
    private static final String USER_FIELD_PREFIX = "com.sun.star.text.fieldmaster.User.";
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeDocument.class);

    public OpenOfficeDocument(Document document, LocalOfficeContext context, DocumentHandlers handlers) {
        PropertyValue[] properties;
        byte[] content;
        this.name = document.getName();
        this.debug = "id=" + document.getId() + ", name=" + this.name;
        XComponentLoader loader = context.getComponentLoader();
        if (loader == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument(this.name));
        }
        if (!(document instanceof CompressedDocumentImpl)) {
            document = new CompressedDocumentImpl(document, handlers);
        }
        try (InputStream input = document.getContent();
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)output);
            content = output.toByteArray();
        }
        catch (Exception exception) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument(this.name), exception);
        }
        ByteArrayToXInputStreamAdapter xstream = new ByteArrayToXInputStreamAdapter(content);
        PropertyValue readOnly = this.property("ReadOnly", Boolean.TRUE);
        PropertyValue hidden = this.property("Hidden", Boolean.TRUE);
        PropertyValue asTemplate = this.property("AsTemplate", true);
        PropertyValue inputStream = this.property("InputStream", xstream);
        String extension = FilenameUtils.getExtension((String)this.name);
        if ("rtf".equalsIgnoreCase(extension)) {
            PropertyValue filter = this.property("FilterName", "Rich Text Format");
            properties = new PropertyValue[]{filter, readOnly, hidden, asTemplate, inputStream};
        } else {
            properties = new PropertyValue[]{readOnly, hidden, asTemplate, inputStream};
        }
        XComponent component = this.run("sending document " + this.debug, () -> {
            try {
                return loader.loadComponentFromURL("private:stream", "_blank", 0, properties);
            }
            catch (Exception exception) {
                throw new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument(this.name), exception);
            }
        });
        if (component == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument(this.name));
        }
        this.document = component;
        this.handlers = handlers;
    }

    public String getName() {
        return this.name;
    }

    public XComponent getComponent() {
        return this.document;
    }

    public List<String> getUserFieldNames() {
        this.getFields();
        return new ArrayList<String>(this.userFields.keySet());
    }

    public String getUserField(String name) {
        this.getFields();
        Field field = this.userFields.get(name);
        if (field == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeField(name, name));
        }
        return this.getContent(field);
    }

    public void setUserField(String name, String value) {
        this.getFields();
        Field field = this.userFields.get(name);
        if (field == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeField(name, name));
        }
        this.setContent(field, value);
    }

    public Map<String, ParameterType> getInputFields() {
        LinkedHashMap<String, ParameterType> result = new LinkedHashMap<String, ParameterType>();
        this.getFields();
        for (Field field : this.inputFields.values()) {
            ParameterType param = new ParameterType(field.getName(), String.class, field.getValue(), field.getContent());
            result.put(field.getName(), param);
        }
        return result;
    }

    public boolean hasInputField(String name) {
        this.getFields();
        return this.inputFields.containsKey(name);
    }

    public boolean hasUserField(String name) {
        this.getFields();
        return this.userFields.containsKey(name);
    }

    public String getInputField(String name) {
        this.getFields();
        Field field = this.inputFields.get(name);
        if (field == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeField(name, name));
        }
        return this.getContent(field);
    }

    public void setInputField(String name, String value) {
        this.getFields();
        Field field = this.inputFields.get(name);
        if (field == null) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeField(name, name));
        }
        this.setContent(field, value);
    }

    public void refresh() {
        this.run("refreshing " + this.debug, () -> {
            XRefreshable refreshable;
            XEnumerationAccess fields = this.getTextFields();
            if (fields != null && (refreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)fields)) != null) {
                refreshable.refresh();
            }
        });
    }

    public byte[] export(String mimeType) {
        return this.run("exporting " + this.debug + " to " + mimeType, () -> {
            PropertyValue[] properties;
            XTextDocument textDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.document);
            if (textDocument == null) {
                throw new OpenOfficeDocumentException(ReportMessages.failedToExportOpenOfficeDocument(this.name));
            }
            XStorable storable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)textDocument);
            if (storable == null) {
                throw new OpenOfficeDocumentException(ReportMessages.failedToExportOpenOfficeDocument(this.name));
            }
            XOutputStreamToByteArrayAdapter stream = new XOutputStreamToByteArrayAdapter();
            PropertyValue outputStream = this.property("OutputStream", stream);
            PropertyValue overwrite = this.property("Overwrite", true);
            switch (mimeType) {
                case "application/pdf": {
                    PropertyValue filter = this.property("FilterName", "writer_pdf_Export");
                    properties = new PropertyValue[]{outputStream, overwrite, filter};
                    break;
                }
                case "application/msword": {
                    PropertyValue filter = this.property("FilterName", "MS Word 97");
                    properties = new PropertyValue[]{outputStream, overwrite, filter};
                    break;
                }
                case "text/plain": {
                    PropertyValue filter = this.property("FilterName", "Text");
                    properties = new PropertyValue[]{outputStream, overwrite, filter};
                    break;
                }
                case "text/html": {
                    PropertyValue filter = this.property("FilterName", "HTML (StarWriter)");
                    properties = new PropertyValue[]{outputStream, overwrite, filter};
                    break;
                }
                default: {
                    properties = new PropertyValue[]{outputStream, overwrite};
                }
            }
            try {
                storable.storeToURL("private:stream", properties);
                stream.closeOutput();
            }
            catch (Exception exception) {
                throw new OpenOfficeDocumentException(ReportMessages.failedToExportOpenOfficeDocument(this.name), exception);
            }
            return stream.getBuffer();
        });
    }

    public Document export(String mimeType, String name) {
        byte[] content = this.export(mimeType);
        switch (mimeType) {
            case "application/pdf": {
                name = this.getFileName(name, "pdf");
                break;
            }
            case "application/msword": {
                name = this.getFileName(name, "doc");
                break;
            }
            case "text/plain": {
                name = this.getFileName(name, "txt");
                break;
            }
            case "text/html": {
                name = this.getFileName(name, "html");
            }
        }
        try {
            DocumentHandler handler = this.handlers.get(name, "document.other", mimeType);
            return handler.create(name, (InputStream)new ByteArrayInputStream(content), mimeType, content.length);
        }
        catch (OpenVPMSException exception) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToExportOpenOfficeDocument(name), exception);
        }
    }

    public void print(PrintProperties properties) {
        this.run("printing " + this.debug, () -> {
            XPrintable printable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.document);
            if (printable == null) {
                throw new OpenOfficeException(ReportMessages.failedToPrintOpenOfficeDocument(this.name));
            }
            int copies = properties.getCopies();
            String printer = properties.getPrinterName();
            Sides sides = properties.getSides();
            Short printSides = this.getDuplexMode(sides);
            PropertyValue[] printerDesc = new PropertyValue[]{this.property("Name", printer)};
            PropertyValue[] printOpts = new PropertyValue[]{this.property("Wait", true), this.property("CopyCount", copies), this.property("DuplexMode", printSides)};
            try {
                printable.setPrinter(printerDesc);
                printable.print(printOpts);
            }
            catch (ReportException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new OpenOfficeException(ReportMessages.failedToPrintOpenOfficeDocument(this.name), exception);
            }
        });
    }

    @Override
    public void close() {
        this.run("closing " + this.debug, () -> {
            try {
                XCloseable closeable;
                XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.document);
                if (model != null && (closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)model)) != null) {
                    closeable.close(false);
                }
            }
            catch (Throwable exception) {
                log.error("Failed to close document", exception);
            }
        });
    }

    protected Map<String, Field> getUserTextFields() {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        XNameAccess fields = this.getTextFieldMasters();
        if (fields != null) {
            for (String elementName : fields.getElementNames()) {
                try {
                    if (!elementName.regionMatches(true, 0, USER_FIELD_PREFIX, 0, USER_FIELD_PREFIX.length())) continue;
                    String name = elementName.substring(USER_FIELD_PREFIX.length());
                    Object fieldMaster = fields.getByName(elementName);
                    XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)fieldMaster);
                    if (propertySet == null) continue;
                    String value = (String)propertySet.getPropertyValue("Content");
                    Field field = new Field(name, value, propertySet);
                    result.put(name, field);
                }
                catch (Exception exception) {
                    throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeUserFields(this.name), exception);
                }
            }
        }
        return result;
    }

    protected Map<String, Field> getInputTextFields() {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        XEnumeration fields = this.getTextFieldsEnumeration();
        if (fields != null) {
            int seed = 0;
            try {
                while (fields.hasMoreElements()) {
                    XPropertySet set = this.getInputFieldPropertySet(fields.nextElement());
                    if (set == null) continue;
                    String name = "inputField" + ++seed;
                    String value = StringUtils.trimToNull((String)((String)set.getPropertyValue("Hint")));
                    String content = StringUtils.trimToNull((String)((String)set.getPropertyValue("Content")));
                    if (value == null) {
                        value = content;
                    }
                    result.put(name, new Field(name, value, set, null, content));
                }
            }
            catch (Throwable exception) {
                throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeInputFields(this.name), exception);
            }
        }
        return result;
    }

    protected void setContent(Field field, String value) {
        try {
            field.getPropertySet().setPropertyValue("Content", (Object)value);
            field.setChanged(true);
        }
        catch (Throwable exception) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToSetOpenOfficeField(field.getName(), this.name), exception);
        }
    }

    protected String getContent(Field field) {
        Object content;
        try {
            content = field.getPropertySet().getPropertyValue("Content");
        }
        catch (Throwable exception) {
            throw new OpenOfficeDocumentException(ReportMessages.failedToGetOpenOfficeField(field.getName(), this.name), exception);
        }
        return content != null ? content.toString() : null;
    }

    protected XTextFieldsSupplier getTextFieldSupplier() {
        return (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)this.document);
    }

    protected XEnumerationAccess getTextFields() {
        XTextFieldsSupplier supplier = this.getTextFieldSupplier();
        return supplier != null ? supplier.getTextFields() : null;
    }

    protected XEnumeration getTextFieldsEnumeration() {
        XEnumerationAccess fields = this.getTextFields();
        return fields != null ? fields.createEnumeration() : null;
    }

    protected XNameAccess getTextFieldMasters() {
        XTextFieldsSupplier textFieldSupplier = this.getTextFieldSupplier();
        return textFieldSupplier != null ? textFieldSupplier.getTextFieldMasters() : null;
    }

    protected boolean isInputField(Object field) {
        XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)field);
        return info != null && info.supportsService("com.sun.star.text.TextField.Input");
    }

    protected XPropertySet getInputFieldPropertySet(Object field) {
        XTextField text = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)field);
        if (text != null && (this.isInputField(text) || this.isInputUserField(text))) {
            return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)text);
        }
        return null;
    }

    private Short getDuplexMode(Sides sides) {
        if (sides != null) {
            if (sides == Sides.ONE_SIDED) {
                return (short)1;
            }
            if (sides == Sides.DUPLEX || sides == Sides.TWO_SIDED_LONG_EDGE) {
                return (short)2;
            }
            if (sides == Sides.TUMBLE || sides == Sides.TWO_SIDED_SHORT_EDGE) {
                return (short)3;
            }
        }
        return (short)0;
    }

    private boolean isInputUserField(Object field) {
        XServiceInfo info = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)field);
        return info != null && info.supportsService("com.sun.star.text.TextField.InputUser");
    }

    private void getFields() {
        if (this.userFields == null || this.inputFields == null) {
            this.run("initialising fields for " + this.debug, () -> {
                this.userFields = this.getUserTextFields();
                this.inputFields = this.getInputTextFields();
            });
        }
    }

    private PropertyValue property(String name, Object value) {
        PropertyValue property = new PropertyValue();
        property.Name = name;
        property.Value = value;
        return property;
    }

    private String getFileName(String name, String ext) {
        return name + "." + ext;
    }

    private void run(String debug, Runnable command) {
        this.run(debug, () -> {
            command.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T run(String debug, Supplier<T> command) {
        StopWatch stopWatch = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Starting " + debug);
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            T t = command.get();
            return t;
        }
        finally {
            if (stopWatch != null) {
                stopWatch.stop();
                log.debug("Completed " + debug + " in " + stopWatch);
            }
        }
    }

    protected static class Field {
        private final String value;
        private final XPropertySet field;
        private final Point position;
        private final String content;
        private String name;
        private boolean changed;

        public Field(String name, String value, XPropertySet properties) {
            this(name, value, properties, null, null);
        }

        public Field(String value, XPropertySet properties, Point position, String content) {
            this(null, value, properties, position, content);
        }

        public Field(String name, String value, XPropertySet properties, Point position, String content) {
            this.name = name;
            this.field = properties;
            this.value = value;
            this.position = position;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public XPropertySet getPropertySet() {
            return this.field;
        }

        public Point getPosition() {
            return this.position;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setChanged(boolean changed) {
            this.changed = changed;
        }
    }
}

