/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.OfficeConnectionException;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeConnectionException;
import org.openvpms.report.openoffice.OpenOfficeException;

class OfficeTaskRunner {
    OfficeTaskRunner() {
    }

    public static void run(Supplier<OfficeManager> officeManager, OfficeTask task) {
        ProtectedTask protectedTask = new ProtectedTask(task);
        try {
            officeManager.get().execute((OfficeTask)protectedTask);
        }
        catch (OfficeConnectionException exception) {
            throw new OpenOfficeConnectionException(ReportMessages.failedToConnectToOpenOffice(exception.getMessage()), exception);
        }
        catch (OfficeException exception) {
            OfficeTaskRunner.rethrow(exception, protectedTask);
        }
    }

    private static void rethrow(OfficeException exception, ProtectedTask task) {
        if (task.caught instanceof OpenVPMSException) {
            throw task.caught;
        }
        if (exception.getCause() instanceof InterruptedException) {
            throw new OpenOfficeException(ReportMessages.openOfficeTaskInterrupted(), exception);
        }
        if (exception.getCause() instanceof CancellationException) {
            throw new OpenOfficeException(ReportMessages.openOfficeTaskCancelled(), exception);
        }
        if (exception.getCause() instanceof TimeoutException) {
            throw new OpenOfficeException(ReportMessages.openOfficeTaskTimedOut(), exception);
        }
        throw new OpenOfficeException(ReportMessages.openOfficeError(), exception);
    }

    static class ProtectedTask
    implements OfficeTask {
        private final OfficeTask task;
        private RuntimeException caught;

        public ProtectedTask(OfficeTask task) {
            this.task = task;
        }

        public void execute(@NonNull OfficeContext context) throws OfficeException {
            try {
                this.task.execute(context);
            }
            catch (OfficeException exception) {
                throw exception;
            }
            catch (RuntimeException exception) {
                this.caught = exception;
                throw exception;
            }
        }
    }
}

