/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import org.apache.commons.jxpath.Functions;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.business.service.archetype.helper.ResolvingPropertySet;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.report.AbstractExpressionEvaluator;
import org.openvpms.report.jasper.AbstractDataSource;
import org.openvpms.report.jasper.ReportContext;

public class JDBCQueryExecuter
extends JRJdbcQueryExecuter {
    private final ReportContext reportContext;
    private final ArchetypeService service;
    private final LookupService lookups;
    private final Map<String, JRField> reportFields = new HashMap<String, JRField>();
    private final Map<String, String> reportParameters = new HashMap<String, String>();

    public JDBCQueryExecuter(JasperReportsContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters, ResolvingPropertySet fields, String reportName, ArchetypeService service, LookupService lookups, Functions functions) {
        super(context, dataset, parameters);
        this.service = service;
        this.lookups = lookups;
        this.reportContext = new ReportContext(null, (PropertySet)fields, reportName, service, lookups, null, functions);
        for (JRField jRField : dataset.getFields()) {
            if (jRField.getName().startsWith("[")) continue;
            this.reportFields.put("F." + jRField.getName(), jRField);
        }
        for (JRField jRField : dataset.getParameters()) {
            if (!jRField.isForPrompting() || jRField.isSystemDefined()) continue;
            this.reportParameters.put("P." + jRField.getName(), jRField.getName());
        }
    }

    public JRDataSource createDatasource() throws JRException {
        return new FieldDataSource(super.createDatasource());
    }

    private class JDBCExpressionEvaluator
    extends AbstractExpressionEvaluator<Object> {
        private final JRDataSource dataSource;

        public JDBCExpressionEvaluator(JRDataSource dataSource, ReportContext context) {
            super(new Object(), context);
            this.dataSource = dataSource;
        }

        public Object getValue(JRField field) throws JRException {
            String expression = field.getName();
            Object result = this.isJXPath(expression) ? this.getJXPathValue(expression) : (this.isField(expression) ? this.getFieldValue(expression) : this.dataSource.getFieldValue(field));
            return result;
        }

        @Override
        protected Object getNodeValue(String name) {
            return null;
        }

        @Override
        protected IMObjectVariables createVariables() {
            return new IMObjectVariables(JDBCQueryExecuter.this.service, JDBCQueryExecuter.this.lookups){

                public boolean exists(String name) {
                    return JDBCQueryExecuter.this.reportFields.containsKey(name) || JDBCQueryExecuter.this.reportParameters.containsKey(name) || super.exists(name);
                }

                public Object getVariable(String varName) {
                    JRField field = (JRField)JDBCQueryExecuter.this.reportFields.get(varName);
                    if (field != null) {
                        try {
                            return JDBCExpressionEvaluator.this.dataSource.getFieldValue(field);
                        }
                        catch (JRException e) {
                            throw new IllegalStateException("Failed to retrieve value for field " + varName, e);
                        }
                    }
                    String parameter = (String)JDBCQueryExecuter.this.reportParameters.get(varName);
                    if (parameter != null) {
                        return JDBCQueryExecuter.this.getParameterValue(parameter);
                    }
                    return super.getVariable(varName);
                }
            };
        }
    }

    private class FieldDataSource
    extends AbstractDataSource {
        private final JRDataSource dataSource;
        private final JDBCExpressionEvaluator evaluator;

        public FieldDataSource(JRDataSource dataSource) {
            super(JDBCQueryExecuter.this.reportContext);
            this.dataSource = dataSource;
            this.evaluator = new JDBCExpressionEvaluator(dataSource, JDBCQueryExecuter.this.reportContext);
        }

        public boolean next() throws JRException {
            return this.dataSource != null && this.dataSource.next();
        }

        public Object getFieldValue(JRField field) throws JRException {
            return this.getFieldValue(field, null);
        }

        @Override
        public Object evaluate(String expression) {
            return this.evaluate(expression, this.evaluator, null);
        }

        @Override
        public Object evaluate(Object object, String expression) {
            return this.evaluate(object, expression, this.evaluator, null);
        }

        @Override
        public JRRewindableDataSource getDataSource(String name, String ... sortNodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JRRewindableDataSource getDataSource(String name, boolean relativeToRoot, String ... sortNodes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JRRewindableDataSource getExpressionDataSource(String expression) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object getValue(JRField field) throws JRException {
            return this.evaluator.getValue(field);
        }
    }
}

