/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.ResolvingPropertySet;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.report.ExpressionEvaluator;
import org.openvpms.report.IMObjectExpressionEvaluator;
import org.openvpms.report.Parameters;
import org.openvpms.report.jasper.AbstractDataSource;
import org.openvpms.report.jasper.IMObjectCollectionDataSource;
import org.openvpms.report.jasper.IMObjectResolver;
import org.openvpms.report.jasper.ReportContext;

public class IMObjectDataSource
extends AbstractDataSource {
    private final IMObject object;
    private final ExpressionEvaluator evaluator;
    private boolean next = true;

    public IMObjectDataSource(IMObject object, Parameters parameters, Map<String, Object> fields, String reportName, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions) {
        this(object, new ReportContext(parameters, (PropertySet)(fields != null ? new ResolvingPropertySet(fields, service, lookups) : null), reportName, service, lookups, handlers, functions));
    }

    protected IMObjectDataSource(IMObject object, ReportContext context) {
        super(context);
        this.object = object;
        NodeResolver resolver = new NodeResolver(object, context.getArchetypeService(), context.getLookupService());
        this.evaluator = new IMObjectExpressionEvaluator(object, resolver, context);
    }

    public boolean next() {
        boolean result = this.next;
        this.next = false;
        return result;
    }

    @Override
    public JRRewindableDataSource getDataSource(String name, String ... sortNodes) throws JRException {
        return this.getDataSource(name, false, sortNodes);
    }

    @Override
    public JRRewindableDataSource getDataSource(String name, boolean relativeToRoot, String ... sortNodes) throws JRException {
        IMObjectResolver resolver = new IMObjectResolver(this.object, this.getContext().getArchetypeService(), this.getContext().getLookupService());
        List<IMObject> values = resolver.getObjects(name, relativeToRoot, sortNodes);
        return new IMObjectCollectionDataSource(values, this.getContext());
    }

    @Override
    public JRRewindableDataSource getExpressionDataSource(String expression) throws JRException {
        return this.getExpressionDataSource(this.object, expression);
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(field, this.object);
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(expression, this.evaluator, this.object);
    }

    @Override
    public Object evaluate(Object object, String expression) {
        return this.evaluate(object, expression, this.evaluator, this.object);
    }

    @Override
    protected Object getValue(JRField field) {
        Object value = this.evaluator.getValue(field.getName());
        if (value instanceof Document) {
            Document doc = (Document)value;
            if (doc.getContents() != null && doc.getContents().length != 0) {
                DocumentHandlers handlers = this.getContext().getDocumentHandlers();
                if (handlers != null) {
                    DocumentHandler handler = handlers.get((org.openvpms.component.model.document.Document)doc);
                    value = handler.getContent((org.openvpms.component.model.document.Document)doc);
                } else {
                    value = null;
                }
            } else {
                value = null;
            }
        }
        return value;
    }
}

