/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.governors.MaxPagesGovernorException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.ParameterType;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.jasper.JDBCQueryExecuterFactory;
import org.openvpms.report.jasper.JDBCQueryExecutorFactoryBundle;
import org.openvpms.report.jasper.JasperIMReport;
import org.openvpms.report.jasper.JasperReportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJasperIMReport<T>
implements JasperIMReport<T> {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final Functions functions;
    private final SimpleJasperReportsContext context;
    private final JDBCQueryExecuterFactory factory;
    private final int maxPages;
    private static final String[] MIME_TYPES = new String[]{"application/pdf", "text/rtf", "application/excel", "text/csv", "text/plain"};
    private static final Logger log = LoggerFactory.getLogger(AbstractJasperIMReport.class);
    private static final String HTML_HEADER = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html>\n<head>\n    <title></title>\n</head>\n<body>";
    private static final String HTML_FOOTER = "</body>\n</html>";

    public AbstractJasperIMReport(ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions, Settings settings) {
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.functions = functions;
        this.context = new SimpleJasperReportsContext();
        this.maxPages = settings.getInt("entity.globalSettingsReport", "maxPages", 1000);
        if (this.maxPages > 0) {
            this.context.setProperty("net.sf.jasperreports.governor.max.pages.enabled", Boolean.toString(true));
            this.context.setProperty("net.sf.jasperreports.governor.max.pages", Integer.toString(this.maxPages));
        }
        this.factory = new JDBCQueryExecuterFactory(service, lookups, functions);
        List<JDBCQueryExecutorFactoryBundle> extensions = Collections.singletonList(new JDBCQueryExecutorFactoryBundle(this.factory));
        this.context.setExtensions(JRQueryExecuterFactoryBundle.class, extensions);
    }

    @Override
    public Set<ParameterType> getParameterTypes() {
        LinkedHashSet<ParameterType> types = new LinkedHashSet<ParameterType>();
        JasperReport report = this.getReport();
        for (JRParameter p : report.getParameters()) {
            if (p.isSystemDefined() || !p.isForPrompting()) continue;
            JRExpression expression = p.getDefaultValueExpression();
            Object defaultValue = null;
            if (expression != null) {
                try {
                    defaultValue = this.getEvaluator().evaluate(expression);
                }
                catch (ReportException exception) {
                    throw exception;
                }
                catch (Throwable exception) {
                    throw new ReportException(ReportMessages.failedToGetParameters(this.getName(), exception.getMessage()), exception);
                }
            }
            ParameterType type = new ParameterType(p.getName(), p.getValueClass(), p.getDescription(), defaultValue);
            types.add(type);
        }
        return types;
    }

    @Override
    public boolean hasParameter(String name) {
        for (JRParameter p : this.getReport().getParameters()) {
            if (!Objects.equals(p.getName(), name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultMimeType() {
        return "application/pdf";
    }

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public Document generate(Map<String, Object> parameters, Map<String, Object> fields) {
        return this.generate(parameters, fields, this.getDefaultMimeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document generate(Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        Document document;
        Map<String, Object> properties = this.getDefaultParameters();
        if (parameters != null) {
            properties.putAll(parameters);
        }
        if (mimeType.equals("text/csv") || mimeType.equals("application/excel")) {
            properties.put("IS_IGNORE_PAGINATION", true);
        }
        JasperReport report = this.getReport();
        MutableObject executor = new MutableObject();
        try {
            document = this.runProtectedReport(() -> {
                executor.setValue((Object)this.initDataSource(properties, fields, report, this.context));
                JasperPrint print = JasperFillManager.getInstance((JasperReportsContext)this.context).fill(report, properties);
                return this.export(print, properties, mimeType);
            });
        }
        finally {
            if (executor.getValue() != null) {
                ((JRQueryExecuter)executor.getValue()).close();
            }
        }
        return document;
    }

    public Document generate(Iterable<T> objects) {
        return this.generate(objects, this.getDefaultMimeType());
    }

    public Document generate(Iterable<T> objects, String mimeType) {
        Map<String, Object> empty = Collections.emptyMap();
        return this.generate(objects, empty, null, mimeType);
    }

    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields) {
        return this.generate(objects, parameters, fields, this.getDefaultMimeType());
    }

    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        Map<String, Object> modifiedParameters = this.getGenerationParameters(parameters, mimeType);
        return this.runProtectedReport(() -> {
            JasperPrint print = this.report(objects, modifiedParameters, fields);
            return this.export(print, modifiedParameters, mimeType);
        });
    }

    @Override
    public void generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType, OutputStream stream) {
        Map<String, Object> modifiedParameters = this.getGenerationParameters(parameters, mimeType);
        this.runProtectedReport(() -> {
            JasperPrint report = this.report(objects, modifiedParameters, fields);
            return this.export(report, stream, modifiedParameters, mimeType);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        Map<String, Object> params = this.getDefaultParameters();
        JasperReport report = this.getReport();
        if (parameters != null) {
            params.putAll(parameters);
        }
        MutableObject executor = new MutableObject();
        try {
            this.printProtectedReport(properties, () -> {
                executor.setValue((Object)this.initDataSource(params, fields, report, this.context));
                JasperPrint print = JasperFillManager.getInstance((JasperReportsContext)this.context).fill(this.getReport(), params);
                this.print(print, properties);
                return null;
            });
        }
        finally {
            if (executor.getValue() != null) {
                ((JRQueryExecuter)executor.getValue()).close();
            }
        }
    }

    @Override
    public void print(Iterable<T> objects, PrintProperties properties) {
        Map<String, Object> empty = Collections.emptyMap();
        this.print(objects, empty, null, properties);
    }

    @Override
    public void print(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        this.printProtectedReport(properties, () -> {
            JasperPrint print = this.report(objects, parameters, fields);
            this.print(print, properties);
            return null;
        });
    }

    protected JasperPrint report(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields) throws JRException {
        JRRewindableDataSource source = this.createDataSource(objects, parameters, fields);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.getDefaultParameters());
        if (parameters != null) {
            properties.putAll(parameters);
        }
        properties.put("dataSource", source);
        properties.put("REPORT_DATA_SOURCE", source);
        return JasperFillManager.getInstance((JasperReportsContext)this.context).fill(this.getReport(), properties, (JRDataSource)source);
    }

    protected abstract JRRewindableDataSource createDataSource(Iterable<T> var1, Map<String, Object> var2, Map<String, Object> var3);

    protected ArchetypeService getArchetypeService() {
        return this.service;
    }

    protected LookupService getLookupService() {
        return this.lookups;
    }

    protected DocumentHandlers getDocumentHandlers() {
        return this.handlers;
    }

    protected Functions getFunctions() {
        return this.functions;
    }

    protected Map<String, Object> getDefaultParameters() {
        return new HashMap<String, Object>();
    }

    protected Document export(JasperPrint report, Map<String, Object> parameters, String mimeType) {
        Document document;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(2048);
            String ext = this.export(report, (OutputStream)output, parameters, mimeType);
            byte[] data = output.toByteArray();
            String name = report.getName() + "." + ext;
            DocumentHandler handler = this.handlers.get(name, "document.other", mimeType);
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            document = handler.create(name, (InputStream)stream, mimeType, data.length);
        }
        catch (JRException exception) {
            throw this.adaptJRException((Exception)((Object)exception), () -> ReportMessages.failedToGenerateReport(this.getName(), exception.getMessage()));
        }
        return document;
    }

    protected String export(JasperPrint report, OutputStream stream, Map<String, Object> parameters, String mimeType) throws JRException {
        String ext;
        if ("application/pdf".equals(mimeType)) {
            this.exportToPDF(report, stream);
            ext = "pdf";
        } else if ("text/html".equals(mimeType)) {
            this.exportToHTML(report, stream);
            ext = "html";
        } else if ("text/rtf".equals(mimeType)) {
            this.exportToRTF(report, stream);
            ext = "rtf";
        } else if ("application/excel".equals(mimeType)) {
            this.exportToXLS(report, stream);
            ext = "xls";
        } else if ("text/csv".equals(mimeType)) {
            this.exportToCSV(report, stream);
            ext = "csv";
        } else if ("text/xml".equals(mimeType)) {
            this.exportToXML(report, stream);
            ext = "xml";
        } else if ("text/plain".equals(mimeType)) {
            this.exportToText(report, stream, parameters);
            ext = "txt";
        } else if ("application/vnd.oasis.opendocument.text".equals(mimeType)) {
            this.exportToODT(report, stream);
            ext = "odt";
        } else if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType)) {
            this.exportToDOCX(report, stream);
            ext = "docx";
        } else {
            throw new ReportException(ReportMessages.cannotConvertJasperReport(this.getName(), mimeType));
        }
        return ext;
    }

    protected abstract JREvaluator getEvaluator() throws JRException;

    protected SimpleJasperReportsContext getJasperReportsContext() {
        return this.context;
    }

    private Map<String, Object> getGenerationParameters(Map<String, Object> parameters, String mimeType) {
        HashMap<String, Object> result;
        HashMap<String, Object> hashMap = result = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        if (mimeType.equals("text/csv") || mimeType.equals("application/excel")) {
            result.put("IS_IGNORE_PAGINATION", true);
        }
        return result;
    }

    private void exportToPDF(JasperPrint report, OutputStream stream) throws JRException {
        this.exportStream(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, OutputStreamExporterOutput>)new JRPdfExporter());
    }

    private void exportToHTML(JasperPrint report, OutputStream stream) throws JRException {
        HtmlExporter exporter = new HtmlExporter();
        SimpleHtmlExporterConfiguration configuration = new SimpleHtmlExporterConfiguration();
        configuration.setHtmlHeader(HTML_HEADER);
        configuration.setHtmlFooter(HTML_FOOTER);
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(report));
        exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(stream));
        exporter.exportReport();
    }

    private void exportToODT(JasperPrint report, OutputStream stream) throws JRException {
        this.exportStream(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, OutputStreamExporterOutput>)new JROdtExporter());
    }

    private void exportToDOCX(JasperPrint report, OutputStream stream) throws JRException {
        this.exportStream(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, OutputStreamExporterOutput>)new JRDocxExporter());
    }

    private void exportToRTF(JasperPrint report, OutputStream stream) throws JRException {
        this.exportWriter(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, WriterExporterOutput>)new JRRtfExporter());
    }

    private void exportToXLS(JasperPrint report, OutputStream stream) throws JRException {
        JRXlsExporter exporter = new JRXlsExporter();
        SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
        configuration.setDetectCellType(Boolean.valueOf(true));
        configuration.setWhitePageBackground(Boolean.valueOf(false));
        configuration.setIgnorePageMargins(Boolean.valueOf(true));
        configuration.setCollapseRowSpan(Boolean.valueOf(true));
        configuration.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        configuration.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)configuration);
        this.exportStream(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, OutputStreamExporterOutput>)exporter);
    }

    private void exportToCSV(JasperPrint report, OutputStream stream) throws JRException {
        JRCsvExporter exporter = new JRCsvExporter();
        SimpleCsvExporterConfiguration configuration = new SimpleCsvExporterConfiguration();
        configuration.setFieldDelimiter(",");
        configuration.setRecordDelimiter("\n");
        exporter.setConfiguration((ExporterConfiguration)configuration);
        this.exportWriter(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, WriterExporterOutput>)exporter);
    }

    private void exportToXML(JasperPrint report, OutputStream stream) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(report));
        exporter.setExporterOutput((ExporterOutput)new SimpleXmlExporterOutput(stream));
        exporter.exportReport();
    }

    private void exportToText(JasperPrint report, OutputStream stream, Map<String, Object> parameters) throws JRException {
        JRTextExporter exporter = new JRTextExporter();
        SimpleReportContext context = JasperReportHelper.createReportContext(parameters);
        exporter.setReportContext((ReportContext)context);
        this.exportWriter(report, stream, (Exporter<ExporterInput, ReportExportConfiguration, ExporterConfiguration, WriterExporterOutput>)exporter);
    }

    private void exportStream(JasperPrint report, OutputStream stream, Exporter<ExporterInput, ? extends ReportExportConfiguration, ? extends ExporterConfiguration, OutputStreamExporterOutput> exporter) throws JRException {
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(report));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(stream));
        exporter.exportReport();
    }

    private void exportWriter(JasperPrint report, OutputStream stream, Exporter<ExporterInput, ? extends ReportExportConfiguration, ? extends ExporterConfiguration, WriterExporterOutput> exporter) throws JRException {
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(report));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(stream));
        exporter.exportReport();
    }

    private void print(JasperPrint print, PrintProperties properties) throws JRException {
        if (print.getPages().isEmpty()) {
            throw new ReportException(ReportMessages.noPagesToPrint(this.getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug("print: {}", (Object)properties);
        }
        PrintService printService = this.getPrintService(properties.getPrinterName());
        HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
        this.addAttribute(set, properties.getMediaSize());
        this.addAttribute(set, properties.getOrientation());
        this.addAttribute(set, properties.getMediaTray());
        this.addAttribute(set, properties.getSides());
        int copies = properties.getCopies();
        int count = 1;
        if (copies > 1) {
            if (this.supportsCopies(printService, copies)) {
                set.add(new Copies(copies));
            } else {
                count = copies;
                log.debug("Multiple copies not supported by '{}', creating {} jobs", (Object)properties.getPrinterName(), (Object)copies);
            }
        }
        SimplePrintServiceExporterConfiguration printConfiguration = new SimplePrintServiceExporterConfiguration();
        printConfiguration.setPrintRequestAttributeSet((PrintRequestAttributeSet)set);
        printConfiguration.setPrintService(printService);
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print));
        exporter.setConfiguration((ExporterConfiguration)printConfiguration);
        for (int i = 0; i < count; ++i) {
            exporter.exportReport();
        }
    }

    private PrintService getPrintService(String printerName) {
        HashPrintServiceAttributeSet serviceAttributeSet = new HashPrintServiceAttributeSet();
        serviceAttributeSet.add(new PrinterName(printerName, null));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, serviceAttributeSet);
        if (services.length <= 0) {
            throw new ReportException(ReportMessages.printerNotFound(printerName));
        }
        PrintService result = services[0];
        return result;
    }

    private void addAttribute(PrintRequestAttributeSet set, PrintRequestAttribute attribute) {
        if (attribute != null) {
            set.add(attribute);
        }
    }

    private boolean supportsCopies(PrintService printService, int copies) {
        CopiesSupported supported = (CopiesSupported)printService.getSupportedAttributeValues(Copies.class, null, null);
        return supported != null && supported.contains(copies);
    }

    private JRQueryExecuter initDataSource(Map<String, Object> params, Map<String, Object> fields, JasperReport report, SimpleJasperReportsContext context) throws JRException {
        JRQueryExecuter executor = null;
        Connection connection = (Connection)params.get("REPORT_CONNECTION");
        if (connection != null) {
            this.factory.setFields(fields);
            this.factory.setReportName(this.getName());
            executor = this.factory.createQueryExecuter((JasperReportsContext)context, report, params);
            JRDataSource dataSource = executor.createDatasource();
            params.put("REPORT_DATA_SOURCE", dataSource);
        }
        return executor;
    }

    private <R> R runProtectedReport(Callable<R> reporter) {
        R result;
        try {
            result = reporter.call();
        }
        catch (ReportException exception) {
            throw exception;
        }
        catch (MaxPagesGovernorException exception) {
            throw new ReportException(ReportMessages.maxPagesExceeded(this.getName(), this.maxPages), exception);
        }
        catch (JRRuntimeException exception) {
            throw this.adaptJRException((Exception)((Object)exception), () -> ReportMessages.failedToGenerateReport(this.getName(), exception.getMessage()));
        }
        catch (JRException exception) {
            throw this.adaptJRException((Exception)((Object)exception), () -> ReportMessages.failedToGenerateReport(this.getName(), exception.getMessage()));
        }
        catch (Throwable exception) {
            throw new ReportException(ReportMessages.failedToGenerateReport(this.getName(), exception.getMessage()), exception);
        }
        return result;
    }

    private void printProtectedReport(PrintProperties properties, Callable<Void> printer) {
        try {
            printer.call();
        }
        catch (ReportException exception) {
            throw exception;
        }
        catch (MaxPagesGovernorException exception) {
            throw new ReportException(ReportMessages.maxPagesExceeded(this.getName(), this.maxPages), exception);
        }
        catch (JRException exception) {
            throw this.adaptJRException((Exception)((Object)exception), () -> ReportMessages.failedToPrintReport(this.getName(), properties.getPrinterName(), exception.getMessage()));
        }
        catch (Throwable exception) {
            throw new ReportException(ReportMessages.failedToPrintReport(this.getName(), properties.getPrinterName(), exception.getMessage()), exception);
        }
    }

    private ReportException adaptJRException(Exception exception, Supplier<Message> fallback) {
        ReportException result = null;
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)exception)) {
            String resource = this.getResourceNotFound(cause);
            if (resource == null) continue;
            result = new ReportException(ReportMessages.reportResourceNotFound(this.getName(), resource), exception);
            break;
        }
        if (result == null) {
            result = new ReportException(fallback.get(), exception);
        }
        return result;
    }

    private String getResourceNotFound(Throwable throwable) {
        JRException exception;
        String key;
        String result = null;
        if (throwable instanceof JRException && ("util.loader.input.stream.from.url.open.error".equals(key = (exception = (JRException)throwable).getMessageKey()) || "repo.byte.data.not.found".equals(key)) && exception.getArgs() != null && exception.getArgs().length == 1) {
            result = exception.getArgs()[0].toString();
        }
        return result;
    }
}

