/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ReadOnlyArchetypeService;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.report.DocFormats;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.IMReport;
import org.openvpms.report.Report;
import org.openvpms.report.ReportException;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.StaticContentIMReport;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.jasper.TemplatedJasperIMObjectReport;
import org.openvpms.report.jasper.TemplatedJasperObjectSetReport;

public abstract class AbstractReportFactory
implements ReportFactory {
    private final DocumentHandlers handlers;
    private final IArchetypeService service;
    private final LookupService lookups;
    private final ArchetypeFunctionsFactory factory;
    private final DocumentRules documentRules;
    private final DocumentConverter documentConverter;
    private final Settings settings;

    public AbstractReportFactory(IArchetypeService service, LookupService lookups, DocumentHandlers handlers, ArchetypeFunctionsFactory factory, DocumentRules documentRules, DocumentConverter documentConverter, Settings settings) {
        this.service = new ReadOnlyArchetypeService(service);
        this.lookups = lookups;
        this.handlers = handlers;
        this.factory = factory;
        this.documentRules = documentRules;
        this.documentConverter = documentConverter;
        this.settings = settings;
    }

    @Override
    public boolean hasMergeableContent(BaseDocumentTemplate template) {
        return this.hasMergeableContent(template.getFileName());
    }

    @Override
    public Report createReport(DocumentTemplate template) {
        Document document = this.getDocument((BaseDocumentTemplate)template);
        String name = document.getName();
        if (!DocFormats.hasExtension(document, "jrxml")) {
            throw new ReportException(ReportMessages.unsupportedTemplate(name));
        }
        IArchetypeService serviceProxy = this.proxy(this.service);
        FunctionLibrary functions = this.factory.create(serviceProxy, true);
        TemplatedJasperIMObjectReport report = new TemplatedJasperIMObjectReport(name, document, (ArchetypeService)serviceProxy, this.lookups, this.handlers, (Functions)functions, this.settings);
        return report;
    }

    @Override
    public boolean isIMObjectReport(BaseDocumentTemplate template) {
        return this.hasMergeableContent(template);
    }

    @Override
    public IMReport<IMObject> createIMObjectReport(BaseDocumentTemplate template) {
        return this.createIMObjectReport(this.getDocument(template), template);
    }

    @Override
    public boolean isObjectSetReport(BaseDocumentTemplate template, int cardinality) {
        boolean result = false;
        String ext = FilenameUtils.getExtension((String)template.getFileName());
        if (ext != null && (this.isJRXML(ext) || cardinality == 1 && this.isDocument(ext))) {
            result = true;
        }
        return result;
    }

    @Override
    public IMReport<ObjectSet> createObjectSetReport(BaseDocumentTemplate template) {
        return this.createObjectSetReport(this.getDocument(template), template);
    }

    @Override
    public IMReport<IMObject> createStaticContentReport(DocumentTemplate template) {
        Document document = this.getDocument((BaseDocumentTemplate)template);
        return this.createStaticContentReport(document);
    }

    @Override
    public IMReport<IMObject> createStaticContentReport(Document document) {
        return new StaticContentIMReport<IMObject>(document, this.documentRules, this.handlers, this.documentConverter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IMReport<IMObject> createIMObjectReport(Document document, BaseDocumentTemplate template) {
        if (!this.hasMergeableContent(document.getName())) throw new ReportException(ReportMessages.unsupportedTemplate(document.getName()));
        IArchetypeService serviceProxy = this.proxy(this.service);
        FunctionLibrary functions = this.factory.create(serviceProxy, true);
        String ext = FilenameUtils.getExtension((String)document.getName());
        if (this.isJRXML(ext)) {
            return new TemplatedJasperIMObjectReport(template.getName(), document, (ArchetypeService)serviceProxy, this.lookups, this.handlers, (Functions)functions, this.settings);
        }
        if (!this.isDocument(ext)) throw new ReportException(ReportMessages.unsupportedTemplate(document.getName()));
        return this.createDocumentReport(document, template, (ArchetypeService)serviceProxy, (Functions)functions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IMReport<ObjectSet> createObjectSetReport(Document document, BaseDocumentTemplate template) {
        String ext = FilenameUtils.getExtension((String)template.getFileName());
        if (ext == null) throw new ReportException(ReportMessages.unsupportedTemplate(document.getName()));
        IArchetypeService serviceProxy = this.proxy(this.service);
        FunctionLibrary functions = this.factory.create(serviceProxy, true);
        if (this.isJRXML(ext)) {
            return new TemplatedJasperObjectSetReport(template.getName(), document, (ArchetypeService)serviceProxy, this.lookups, this.handlers, (Functions)functions, this.settings);
        }
        if (!this.isODT(ext)) throw new ReportException(ReportMessages.unsupportedTemplate(document.getName()));
        return this.createDocumentObjectSetReport(document, template, (ArchetypeService)serviceProxy, (Functions)functions);
    }

    protected abstract IMReport<IMObject> createDocumentReport(Document var1, BaseDocumentTemplate var2, ArchetypeService var3, Functions var4);

    protected abstract IMReport<ObjectSet> createDocumentObjectSetReport(Document var1, BaseDocumentTemplate var2, ArchetypeService var3, Functions var4);

    protected IArchetypeService proxy(IArchetypeService service) {
        return new ReadOnlyArchetypeService(service);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected DocumentHandlers getHandlers() {
        return this.handlers;
    }

    protected LookupService getLookups() {
        return this.lookups;
    }

    protected boolean isJRXML(String ext) {
        return ext.equalsIgnoreCase("jrxml");
    }

    protected boolean isDocument(String ext) {
        return this.isODT(ext) || this.isDOC(ext);
    }

    protected boolean isODT(String ext) {
        return StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"odt");
    }

    protected boolean isDOC(String ext) {
        return StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"doc");
    }

    protected boolean hasMergeableContent(String fileName) {
        String ext = FilenameUtils.getExtension((String)fileName);
        return ext != null && (this.isDocument(ext) || this.isJRXML(ext));
    }

    private Document getDocument(BaseDocumentTemplate template) {
        Document document = template.getDocument();
        if (document == null) {
            throw new ReportException(ReportMessages.templateHasNoDocument(template.getName()));
        }
        return document;
    }
}

