/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.local.office.LocalOfficeContext;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.ExpressionEvaluator;
import org.openvpms.report.ExpressionEvaluatorFactory;
import org.openvpms.report.IMReport;
import org.openvpms.report.ParameterType;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeDocument;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.report.openoffice.OpenOfficeTask;
import org.openvpms.report.util.ProtectedExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeIMReport<T>
implements IMReport<T> {
    private final Document template;
    private final ArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final Functions functions;
    private final OpenOfficeService officeService;
    private Map<String, ParameterType> parameters;
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeIMReport.class);
    private static final String IS_EMAIL = "IsEmail";

    public OpenOfficeIMReport(Document template, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions, OpenOfficeService officeService) {
        this.template = template;
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.functions = functions;
        this.officeService = officeService;
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    @Override
    public Set<ParameterType> getParameterTypes() {
        Map<String, ParameterType> params = this.getParameters();
        return new LinkedHashSet<ParameterType>(params.values());
    }

    @Override
    public boolean hasParameter(String name) {
        return this.getParameters().containsKey(name);
    }

    @Override
    public String getDefaultMimeType() {
        String mimeType = this.template.getMimeType();
        if (!ArrayUtils.contains((Object[])this.getMimeTypes(), (Object)mimeType)) {
            mimeType = "application/pdf";
        }
        return mimeType;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.oasis.opendocument.text", "application/msword", "application/pdf", "text/plain"};
    }

    @Override
    public Document generate(Map<String, Object> parameters, Map<String, Object> fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document generate(Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document generate(Iterable<T> objects) {
        return this.generate(objects, this.getDefaultMimeType());
    }

    @Override
    public Document generate(Iterable<T> objects, String mimeType) {
        Map<String, Object> empty = Collections.emptyMap();
        return this.generate(objects, empty, null, mimeType);
    }

    @Override
    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields) {
        return this.generate(objects, parameters, fields, this.getDefaultMimeType());
    }

    @Override
    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        try {
            return this.withOpenOffice("generate", context -> {
                try (OpenOfficeDocument doc = this.create(objects, parameters, fields, (LocalOfficeContext)context);){
                    Document document = this.export(doc, mimeType);
                    return document;
                }
            });
        }
        catch (ReportException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new ReportException(ReportMessages.failedToGenerateReport(this.template.getName(), exception.getMessage()), exception);
        }
    }

    @Override
    public void generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType, OutputStream stream) {
        try {
            this.withOpenOffice("generate", context -> {
                try (OpenOfficeDocument doc = this.create(objects, parameters, fields, (LocalOfficeContext)context);){
                    byte[] content = doc.export(mimeType);
                    stream.write(content);
                }
                catch (ReportException exception) {
                    throw exception;
                }
                catch (Throwable exception) {
                    throw new ReportException(ReportMessages.failedToGenerateReport(this.template.getName(), exception.getMessage()), exception);
                }
                return null;
            });
        }
        catch (ReportException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new ReportException(ReportMessages.failedToGenerateReport(this.template.getName(), exception.getMessage()), exception);
        }
    }

    @Override
    public boolean canPrint() {
        return true;
    }

    @Override
    public void print(Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void print(Iterable<T> objects, PrintProperties properties) {
        this.print(objects, Collections.emptyMap(), null, properties);
    }

    @Override
    public void print(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        try {
            this.withOpenOffice("print", context -> {
                try (OpenOfficeDocument doc = this.create(objects, parameters, fields, (LocalOfficeContext)context);){
                    doc.print(properties);
                }
                return null;
            });
        }
        catch (ReportException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new ReportException(ReportMessages.failedToPrintReport(this.template.getName(), properties.getPrinterName(), exception.getMessage()), exception);
        }
    }

    protected OpenOfficeDocument create(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, LocalOfficeContext context) {
        Iterator<T> iter = objects.iterator();
        T object = null;
        if (iter.hasNext()) {
            object = iter.next();
        }
        if (object == null || iter.hasNext()) {
            throw new ReportException(ReportMessages.failedToGenerateReport(this.template.getName(), "Can only report on single objects"));
        }
        OpenOfficeDocument doc = this.createDocument(this.template, context, this.handlers);
        if (parameters != null) {
            this.populateInputFields(doc, parameters);
        }
        this.populateUserFields(doc, object, parameters, fields);
        doc.refresh();
        return doc;
    }

    protected Set<String> getInputFields(OpenOfficeDocument document) {
        Map<String, ParameterType> fields = document.getInputFields();
        return fields.keySet();
    }

    protected OpenOfficeDocument createDocument(Document template, LocalOfficeContext context, DocumentHandlers handlers) {
        return new OpenOfficeDocument(template, context, handlers);
    }

    protected void populateInputFields(OpenOfficeDocument document, Map<String, Object> parameters) {
        for (Map.Entry<String, Object> p : parameters.entrySet()) {
            String name = p.getKey();
            if (!document.hasInputField(name)) continue;
            String value = p.getValue() != null ? p.getValue().toString() : null;
            document.setInputField(name, value);
        }
    }

    protected void populateUserFields(OpenOfficeDocument document, T object, Map<String, Object> parameters, Map<String, Object> fields) {
        ExpressionEvaluator eval = ExpressionEvaluatorFactory.create(object, fields, this.template.getName(), this.service, this.lookups, this.functions);
        ProtectedExpressionEvaluator evaluator = new ProtectedExpressionEvaluator(this.getName(), log);
        List<String> userFields = document.getUserFieldNames();
        for (String name : userFields) {
            String value = this.getParameter(name, parameters);
            if (value == null && !StringUtils.isEmpty((CharSequence)(value = document.getUserField(name)))) {
                IMObject current = object instanceof IMObject ? (IMObject)object : null;
                value = evaluator.getFormattedValue(value, eval, (org.openvpms.component.model.object.IMObject)current);
            }
            document.setUserField(name, value);
        }
    }

    private <R> R withOpenOffice(String action, Function<LocalOfficeContext, R> function) {
        Task<R> task = new Task<R>(action, function);
        return (R)task.run(this.officeService);
    }

    private String getParameter(String name, Map<String, Object> parameters) {
        Object value;
        String result = null;
        if (parameters != null && (value = parameters.get(name)) != null) {
            result = value.toString();
        }
        return result;
    }

    private Map<String, ParameterType> getParameters() {
        if (this.parameters == null) {
            try {
                this.withOpenOffice("get parameters", context -> {
                    try (OpenOfficeDocument doc = this.createDocument(this.template, (LocalOfficeContext)context, this.handlers);){
                        this.parameters = doc.getInputFields();
                        if (doc.hasUserField(IS_EMAIL)) {
                            this.parameters.put(IS_EMAIL, new ParameterType(IS_EMAIL, Boolean.TYPE, IS_EMAIL, true, false));
                        }
                    }
                    return null;
                });
            }
            catch (ReportException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new ReportException(ReportMessages.failedToGetOpenOfficeInputFields(this.getName()), exception);
            }
        }
        return this.parameters;
    }

    private Document export(OpenOfficeDocument doc, String mimeType) {
        String name = this.template.getName();
        if (!"application/vnd.oasis.opendocument.text".equals(mimeType)) {
            name = FilenameUtils.removeExtension((String)name);
        }
        return doc.export(mimeType, name);
    }

    private class Task<R>
    extends OpenOfficeTask<R> {
        private final String action;
        private final Function<LocalOfficeContext, R> function;

        public Task(String action, Function<LocalOfficeContext, R> function) {
            super(log.isDebugEnabled());
            this.action = action;
            this.function = function;
        }

        @Override
        protected R run(LocalOfficeContext context) {
            return this.function.apply(context);
        }

        @Override
        protected void start() {
            log.debug("Running {}, document='{}'", (Object)this.action, (Object)OpenOfficeIMReport.this.getName());
        }

        @Override
        protected void stop(Exception exception, long delay, long elapsed) {
            if (exception != null) {
                log.debug("Failed to {}, document='{}', delay={}, elapsed={}: {}", new Object[]{this.action, OpenOfficeIMReport.this.getName(), this.duration(delay), this.duration(elapsed), exception.getMessage(), exception});
            } else {
                log.debug("Completed {}, document='{}', delay={}, elapsed={}", new Object[]{this.action, OpenOfficeIMReport.this.getName(), this.duration(delay), this.duration(elapsed)});
            }
        }
    }
}

