/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.openoffice;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.openvpms.archetype.rules.settings.Settings;

public class OpenOfficeConfig {
    public static final int DEFAULT_PORT = 8100;
    public static final int DEFAULT_MAX_TASKS_PER_PROCESS = 200;
    public static final String PATH = "path";
    public static final String PORTS = "ports";
    public static final String MAX_TASKS = "maxTasksPerProcess";
    private final String path;
    private final List<Integer> ports;
    private final int maxTasksPerProcess;

    public OpenOfficeConfig() {
        this.path = OpenOfficeConfig.getDefaultPath();
        this.ports = this.getDefaultPort();
        this.maxTasksPerProcess = 200;
    }

    public OpenOfficeConfig(Settings settings) {
        this.path = this.getPath(settings);
        this.ports = this.getPorts(settings);
        this.maxTasksPerProcess = settings.getInt("entity.globalSettingsOpenOffice", MAX_TASKS, 200);
    }

    public String getPath() {
        return this.path;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public int getMaxTasksPerProcess() {
        return this.maxTasksPerProcess;
    }

    public static String getDefaultPath() {
        return LocalOfficeUtils.getDefaultOfficeHome().getAbsolutePath();
    }

    private String getPath(Settings settings) {
        String result = settings.getString("entity.globalSettingsOpenOffice", PATH, null);
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = OpenOfficeConfig.getDefaultPath();
        }
        return result;
    }

    private List<Integer> getPorts(Settings settings) {
        List<Integer> result = null;
        String string = settings.getString("entity.globalSettingsOpenOffice", PORTS, null);
        if (!StringUtils.isEmpty((CharSequence)string) && !(result = Stream.of(string.split("\\s*,\\s*")).mapToInt(str -> NumberUtils.toInt((String)str, (int)-1)).filter(port -> port != -1).sorted().distinct().boxed().collect(Collectors.toList())).isEmpty()) {
            result = Collections.unmodifiableList(result);
        }
        if (result == null || result.isEmpty()) {
            result = this.getDefaultPort();
        }
        return result;
    }

    private List<Integer> getDefaultPort() {
        return Collections.singletonList(8100);
    }
}

