/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.report.ObjectSetExpressionEvaluator;
import org.openvpms.report.Parameters;
import org.openvpms.report.jasper.AbstractDataSource;
import org.openvpms.report.jasper.ReportContext;

class ObjectSetDataSource
extends AbstractDataSource
implements JRRewindableDataSource {
    private final Iterable<ObjectSet> collection;
    private ObjectSetExpressionEvaluator current;
    private Iterator<ObjectSet> iterator;

    public ObjectSetDataSource(Iterable<ObjectSet> collection, Parameters parameters, PropertySet fields, String reportName, ArchetypeService service, LookupService lookups, DocumentHandlers handlers, Functions functions) {
        super(new ReportContext(parameters, fields, reportName, service, lookups, handlers, functions));
        this.collection = collection;
        this.iterator = collection.iterator();
    }

    public boolean next() throws JRException {
        try {
            if (this.iterator.hasNext()) {
                this.current = new ObjectSetExpressionEvaluator(this.iterator.next(), this.getContext());
                return true;
            }
            return false;
        }
        catch (Throwable exception) {
            throw new JRException(exception);
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(field, null);
    }

    @Override
    public Object evaluate(String expression) {
        return this.current != null ? this.evaluate(expression, this.current, null) : null;
    }

    @Override
    public Object evaluate(Object object, String expression) {
        return this.current != null ? this.evaluate(object, expression, this.current, null) : null;
    }

    public void moveFirst() {
        this.iterator = this.collection.iterator();
    }

    @Override
    public JRRewindableDataSource getDataSource(String name) throws JRException {
        Object value = this.current.getNodeValue(name);
        return this.getCollectionDataSource(value, name);
    }

    @Override
    public JRRewindableDataSource getDataSource(String name, boolean relativeToRoot, String ... sortNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRRewindableDataSource getExpressionDataSource(String expression) throws JRException {
        return this.getExpressionDataSource(this.current.getObject(), expression);
    }

    @Override
    protected Object getValue(JRField field) {
        return this.current.getValue(field.getName());
    }
}

