/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report.jasper;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;

public class JasperTemplateLoader
implements RepositoryService {
    private final String name;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;
    private final JasperReportsContext context;
    private final JasperReport report;
    private final Map<String, JasperReport> subReports = new HashMap<String, JasperReport>();
    private JREvaluator evaluator;

    public JasperTemplateLoader(org.openvpms.component.model.document.Document template, ArchetypeService service, DocumentHandlers handlers, JasperReportsContext context) {
        this.name = template.getName();
        this.service = service;
        this.context = context;
        this.handlers = handlers;
        try {
            DocumentHandler handler = handlers.get(template);
            try (InputStream stream = handler.getContent(template);){
                JasperDesign design = JRXmlLoader.load((JasperReportsContext)context, (InputStream)stream);
                this.report = this.compile(design);
            }
        }
        catch (IOException | JRException | DocumentException exception) {
            throw new ReportException(ReportMessages.failedToCreateReport(template.getName(), exception.getMessage()), exception);
        }
    }

    public JasperReport getReport() {
        return this.report;
    }

    public JREvaluator getEvaluator() throws JRException {
        if (this.evaluator == null) {
            this.evaluator = JasperCompileManager.loadEvaluator((JasperReport)this.report);
        }
        return this.evaluator;
    }

    public Resource getResource(String uri) {
        return null;
    }

    public Map<String, JasperReport> getSubReports() {
        return this.subReports;
    }

    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        if (resourceType.isAssignableFrom(ReportResource.class)) {
            JasperReport report = this.getSubreport(uri);
            ReportResource resource = new ReportResource();
            resource.setReport(report);
            return (K)((Resource)resourceType.cast(resource));
        }
        return null;
    }

    protected JasperReport compile(JasperDesign design) {
        JasperReport result;
        try {
            result = JasperCompileManager.compileReport((JasperDesign)design);
        }
        catch (JRException exception) {
            throw new ReportException(ReportMessages.failedToCreateReport(this.name, exception.getMessage()), exception);
        }
        return result;
    }

    protected JasperReport getSubreport(String name) {
        JasperReport compiled = this.subReports.get(name);
        if (compiled == null) {
            try {
                JasperDesign report = this.getReport(name);
                if (report == null) {
                    throw new ReportException(ReportMessages.failedToFindSubReport(name, this.name));
                }
                compiled = JasperCompileManager.compileReport((JasperDesign)report);
                this.subReports.put(name, compiled);
            }
            catch (JRException | DocumentException exception) {
                throw new ReportException(ReportMessages.failedToFindSubReport(name, this.name), exception);
            }
        }
        return compiled;
    }

    protected org.openvpms.component.model.document.Document getDocument(String name) {
        TemplateHelper helper = new TemplateHelper(this.service);
        Document document = helper.getDocument(name);
        if (document == null) {
            throw new ReportException(ReportMessages.failedToFindSubReport(name, this.name));
        }
        return document;
    }

    private JasperDesign getReport(String name) throws JRException {
        JasperDesign design;
        org.openvpms.component.model.document.Document document = this.getDocument(name);
        DocumentHandler handler = this.handlers.get(document);
        try (InputStream stream = handler.getContent(document);){
            design = JRXmlLoader.load((JasperReportsContext)this.context, (InputStream)stream);
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, (Throwable)exception, new Object[]{name});
        }
        return design;
    }
}

