/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.model.document.Document;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.IMReport;
import org.openvpms.report.ParameterType;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;

public class StaticContentIMReport<T>
implements IMReport<T> {
    private final Document document;
    private final DocumentRules rules;
    private final DocumentHandlers handlers;
    private final DocumentConverter converter;

    public StaticContentIMReport(Document document, DocumentRules rules, DocumentHandlers handlers, DocumentConverter converter) {
        this.document = document;
        this.rules = rules;
        this.handlers = handlers;
        this.converter = converter;
    }

    @Override
    public Document generate(Iterable<T> objects) {
        return this.copy();
    }

    @Override
    public Document generate(Iterable<T> objects, String mimeType) {
        return this.generate(mimeType);
    }

    @Override
    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields) {
        return this.copy();
    }

    @Override
    public Document generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        return this.generate(mimeType);
    }

    @Override
    public void generate(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, String mimeType, OutputStream stream) {
        Document result = this.convert(mimeType);
        DocumentHandler handler = this.handlers.get(result);
        try (InputStream input = handler.getContent(result);){
            IOUtils.copy((InputStream)input, (OutputStream)stream);
        }
        catch (IOException exception) {
            throw new ReportException(ReportMessages.failedToGenerateReport(this.getName(), exception.getMessage()), exception);
        }
    }

    @Override
    public void print(Iterable<T> objects, PrintProperties properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void print(Iterable<T> objects, Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.document.getName();
    }

    @Override
    public Set<ParameterType> getParameterTypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean hasParameter(String name) {
        return false;
    }

    @Override
    public String getDefaultMimeType() {
        return this.document.getMimeType();
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{this.document.getMimeType()};
    }

    @Override
    public Document generate(Map<String, Object> parameters, Map<String, Object> fields) {
        return this.copy();
    }

    @Override
    public Document generate(Map<String, Object> parameters, Map<String, Object> fields, String mimeType) {
        return this.generate(mimeType);
    }

    @Override
    public boolean canPrint() {
        return false;
    }

    @Override
    public void print(Map<String, Object> parameters, Map<String, Object> fields, PrintProperties properties) {
        throw new UnsupportedOperationException();
    }

    private Document generate(String mimeType) {
        Document result = this.convert(mimeType);
        if (result == this.document) {
            result = this.copy();
        }
        return result;
    }

    private Document copy() {
        return this.rules.copy(this.document);
    }

    private Document convert(String mimeType) {
        Document result = this.document;
        if (this.document.getMimeType() != null && !this.document.getMimeType().equalsIgnoreCase(mimeType) && this.converter.canConvert(this.document, mimeType)) {
            result = this.converter.convert(this.document, mimeType);
        }
        return result;
    }
}

