/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.component.system.common.util.PropertyState;
import org.openvpms.report.ExpressionEvaluator;
import org.openvpms.report.Parameters;
import org.openvpms.report.jasper.ReportContext;

public abstract class AbstractExpressionEvaluator<T>
implements ExpressionEvaluator {
    private final T object;
    private final ReportContext context;
    private JXPathContext expressionContext;

    public AbstractExpressionEvaluator(T object, ReportContext context) {
        this.object = object;
        this.context = context;
    }

    public T getObject() {
        return this.object;
    }

    @Override
    public Object getValue(String expression) {
        Object result = this.isJXPath(expression) ? this.getJXPathValue(expression) : (this.isField(expression) ? this.getFieldValue(expression) : this.getNodeValue(expression));
        return result;
    }

    @Override
    public Object evaluate(String expression) {
        return this.getExpressionContext().getValue(expression);
    }

    @Override
    public Object evaluate(Object object, String expression) {
        return this.getExpressionContext(object).getValue(expression);
    }

    @Override
    public String getFormattedValue(String expression) {
        Object value = this.getValue(expression);
        if (value instanceof Date) {
            Date date = (Date)value;
            return DateFormat.getDateInstance(2).format(date);
        }
        if (value instanceof Money) {
            return NumberFormat.getCurrencyInstance().format(value);
        }
        if (value instanceof BigDecimal) {
            DecimalFormat format = new DecimalFormat("#,##0.00;-#,##0.00");
            return format.format(value);
        }
        if (value instanceof IMObject) {
            return this.getValue((IMObject)value);
        }
        if (value instanceof Reference) {
            return this.getValue((Reference)value);
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected Object getJXPathValue(String expression) {
        String eval = expression.substring(1, expression.length() - 1);
        return this.evaluate(eval);
    }

    protected abstract Object getNodeValue(String var1);

    protected Object getFieldValue(String name) {
        return this.getValue(this.context.getFields().resolve(name));
    }

    protected ArchetypeService getService() {
        return this.context.getArchetypeService();
    }

    protected LookupService getLookups() {
        return this.context.getLookupService();
    }

    protected boolean isField(String expression) {
        PropertySet fields = this.context.getFields();
        return fields != null && fields.exists(expression);
    }

    protected boolean isJXPath(String expression) {
        return expression.startsWith("[") && expression.endsWith("]");
    }

    protected IMObjectVariables createVariables() {
        Parameters parameters = this.context.getParameters();
        ArchetypeService service = this.getService();
        LookupService lookups = this.getLookups();
        return parameters != null && !parameters.isEmpty() ? new Variables(parameters, service, lookups) : new IMObjectVariables(service, lookups);
    }

    protected String getValue(IMObject object) {
        String value = null;
        if (object instanceof Relationship) {
            value = this.getValue(((Relationship)object).getTarget());
        } else if (object != null && (value = object.getName()) == null) {
            value = object.getDescription();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getValue(Reference ref) {
        IMObject object = ref != null ? this.getService().get(ref) : null;
        return object != null ? this.getValue(object) : null;
    }

    protected Object getValue(String name, PropertyResolver resolver) {
        PropertyState state = resolver.resolve(name);
        return this.getValue(state);
    }

    private JXPathContext getExpressionContext() {
        if (this.expressionContext == null) {
            this.expressionContext = this.getExpressionContext(this.object);
        }
        return this.expressionContext;
    }

    private JXPathContext getExpressionContext(Object object) {
        JXPathContext result = JXPathHelper.newContext((Object)object, (Functions)this.context.getFunctions());
        PropertySet fields = this.context.getFields();
        if (fields != null || this.context.getParameters() != null) {
            IMObjectVariables variables = this.createVariables();
            if (fields != null) {
                for (String name : fields.getNames()) {
                    Object value = fields.get(name);
                    if (value == null) continue;
                    variables.add(name, value);
                }
            }
            result.setVariables((org.apache.commons.jxpath.Variables)variables);
        }
        return result;
    }

    private Object getValue(PropertyState state) {
        Object result = null;
        NodeDescriptor descriptor = state.getNode();
        Object value = descriptor != null && descriptor.isLookup() ? LookupHelper.getName((ArchetypeService)this.getService(), (LookupService)this.getLookups(), (NodeDescriptor)descriptor, (IMObject)state.getParent()) : state.getValue();
        if (value != null) {
            if (state.getNode() != null && state.getNode().isCollection()) {
                if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    StringBuilder descriptions = new StringBuilder();
                    for (IMObject object : values) {
                        descriptions.append(this.getValue(object));
                        descriptions.append('\n');
                    }
                    result = descriptions.toString();
                } else if (value instanceof IMObject) {
                    IMObject object = (IMObject)value;
                    result = this.getValue(object);
                } else {
                    result = value;
                }
            } else {
                result = value;
            }
        }
        return result;
    }

    protected static class Variables
    extends IMObjectVariables {
        private final Parameters parameters;

        public Variables(Parameters parameters, ArchetypeService service, LookupService lookups) {
            super(service, lookups);
            this.parameters = parameters;
        }

        public boolean exists(String name) {
            return super.exists(name) || this.parameters.exists(name);
        }

        public Object getVariable(String varName) {
            if (this.parameters.exists(varName)) {
                return this.parameters.get(varName);
            }
            return super.getVariable(varName);
        }
    }
}

