/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.report;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.maven.archetype.AbstractHibernateMojo;
import org.openvpms.report.tools.TemplateLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

@Mojo(name="load")
public class ReportLoadMojo
extends AbstractHibernateMojo {
    @Parameter(required=true)
    private File[] files;

    protected void doExecute() throws MojoExecutionException {
        if (this.files == null || this.files.length == 0) {
            throw new MojoExecutionException("No files specified");
        }
        for (File file : this.files) {
            if (file.exists()) continue;
            throw new MojoExecutionException("File does not exist: " + file);
        }
        try {
            ApplicationContext context = this.getContext();
            IArchetypeService service = (IArchetypeService)context.getBean(IArchetypeRuleService.class);
            DocumentHandlers handlers = (DocumentHandlers)context.getBean(DocumentHandlers.class);
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
            LookupService lookups = (LookupService)context.getBean(LookupService.class);
            TemplateLoader loader = new TemplateLoader(service, handlers, transactionManager, lookups);
            for (File file : this.files) {
                this.getLog().info((CharSequence)("Loading: " + file.getPath()));
                loader.load(file.getPath());
            }
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to load report templates", exception);
        }
    }

    protected String[] getContextPaths() {
        return new String[]{"mavenPluginApplicationContext.xml", "reportContext.xml"};
    }
}

