/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.print.test;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.domain.practice.Location;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.DocumentPrinterService;
import org.springframework.beans.factory.DisposableBean;

public class TestDocumentPrinterService
implements DocumentPrinterService,
DisposableBean {
    private final Map<String, DocumentPrinter> printers = new LinkedHashMap<String, DocumentPrinter>();
    private DocumentPrinter defaultPrinter;

    public String getName() {
        return "Test Document Printer Service";
    }

    public synchronized DocumentPrinter getDefaultPrinter() {
        return this.defaultPrinter;
    }

    public synchronized void setDefaultPrinter(DocumentPrinter defaultPrinter) {
        this.defaultPrinter = defaultPrinter;
    }

    public DocumentPrinter getDefaultPrinter(Location location) {
        return this.getDefaultPrinter();
    }

    public synchronized DocumentPrinter getPrinter(String id) {
        return this.printers.get(id);
    }

    public List<DocumentPrinter> getPrinters(Location location) {
        return this.getPrinters();
    }

    public synchronized List<DocumentPrinter> getPrinters() {
        return new ArrayList<DocumentPrinter>(this.printers.values());
    }

    public synchronized void addPrinter(DocumentPrinter printer) {
        this.printers.put(printer.getId(), printer);
    }

    public synchronized void reset() {
        this.printers.clear();
        this.defaultPrinter = null;
    }

    public void destroy() {
        this.reset();
    }

    public String getArchetype() {
        return null;
    }
}

