/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.print.impl.locator;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.domain.practice.Location;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.DocumentPrinterService;

public class DefaultDocumentPrinterServiceLocator
implements DocumentPrinterServiceLocator {
    private final DocumentPrinterService defaultService;
    private final PluginManager manager;

    public DefaultDocumentPrinterServiceLocator(DocumentPrinterService printerService) {
        this(printerService, null);
    }

    public DefaultDocumentPrinterServiceLocator(DocumentPrinterService printerService, PluginManager manager) {
        this.defaultService = printerService;
        this.manager = manager;
    }

    public DocumentPrinter getPrinter(String archetype, String id) {
        if (archetype == null) {
            return this.defaultService.getPrinter(id);
        }
        for (DocumentPrinterService service : this.getServices()) {
            if (!archetype.equals(service.getArchetype())) continue;
            return service.getPrinter(id);
        }
        return null;
    }

    public DocumentPrinter getDefaultPrinter() {
        for (DocumentPrinterService service : this.getServices()) {
            DocumentPrinter printer = service.getDefaultPrinter();
            if (printer == null) continue;
            return printer;
        }
        return null;
    }

    public DocumentPrinter getDefaultPrinter(Location location) {
        for (DocumentPrinterService service : this.getServices()) {
            DocumentPrinter printer = service.getDefaultPrinter(location);
            if (printer == null) continue;
            return printer;
        }
        return null;
    }

    public List<DocumentPrinter> getPrinters(Location location) {
        ArrayList<DocumentPrinter> result = new ArrayList<DocumentPrinter>();
        for (DocumentPrinterService service : this.getServices()) {
            result.addAll(service.getPrinters(location));
        }
        return result;
    }

    public List<DocumentPrinter> getPrinters() {
        ArrayList<DocumentPrinter> result = new ArrayList<DocumentPrinter>();
        for (DocumentPrinterService service : this.getServices()) {
            result.addAll(service.getPrinters());
        }
        return result;
    }

    public List<DocumentPrinterService> getServices() {
        ArrayList<DocumentPrinterService> result = new ArrayList<DocumentPrinterService>();
        result.add(this.defaultService);
        if (this.manager != null) {
            result.addAll(this.manager.getServices(DocumentPrinterService.class));
        }
        return result;
    }

    public DocumentPrinterService getJavaPrintService() {
        return this.defaultService;
    }
}

