/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.print.impl.service;

import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.domain.practice.Location;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.DocumentPrinterService;

public abstract class AbstractPrintServiceDocumentPrinterService
implements DocumentPrinterService {
    private final DocumentHandlers handlers;

    protected AbstractPrintServiceDocumentPrinterService(DocumentHandlers handlers) {
        this.handlers = handlers;
    }

    public DocumentPrinter getDefaultPrinter() {
        PrintService result = PrintServiceLookup.lookupDefaultPrintService();
        return result != null ? this.createDocumentPrinter(result, this.handlers) : null;
    }

    public DocumentPrinter getDefaultPrinter(Location location) {
        return this.getDefaultPrinter();
    }

    public DocumentPrinter getPrinter(String id) {
        HashAttributeSet set = new HashAttributeSet();
        set.add(new PrinterName(id, null));
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, set);
        return printServices.length > 0 ? this.createDocumentPrinter(printServices[0], this.handlers) : null;
    }

    public List<DocumentPrinter> getPrinters() {
        ArrayList<DocumentPrinter> result = new ArrayList<DocumentPrinter>();
        for (PrintService printer : PrintServiceLookup.lookupPrintServices(null, null)) {
            result.add(this.createDocumentPrinter(printer, this.handlers));
        }
        return result;
    }

    public List<DocumentPrinter> getPrinters(Location location) {
        return this.getPrinters();
    }

    public String getArchetype() {
        return null;
    }

    protected abstract DocumentPrinter createDocumentPrinter(PrintService var1, DocumentHandlers var2);
}

