/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.print.impl.service;

import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.print.exception.PrinterException;
import org.openvpms.print.impl.exception.PrintNotSupported;
import org.openvpms.print.impl.i18n.PrintMessages;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.PrintAttributes;

public class AbstractPrintServiceDocumentPrinter
implements DocumentPrinter {
    private final PrintService printService;
    private final DocumentHandlers handlers;
    private static final String PDF = "application/pdf";

    public AbstractPrintServiceDocumentPrinter(PrintService printService, DocumentHandlers handlers) {
        this.printService = printService;
        this.handlers = handlers;
    }

    public String getId() {
        return this.printService.getName();
    }

    public String getName() {
        return this.printService.getName();
    }

    public String getArchetype() {
        return null;
    }

    public boolean canUseJavaPrintServiceAPI() {
        return true;
    }

    public boolean canPrint(String mimeType) {
        if (this.supports(mimeType)) {
            return true;
        }
        return PDF.equalsIgnoreCase(mimeType);
    }

    public void print(Document document, PrintAttributes attributes) {
        if (this.supports((document = this.getDecompressedDocument(document)).getMimeType())) {
            this.printDocument(document, attributes);
        } else if (PDF.equalsIgnoreCase(document.getMimeType())) {
            this.printPDF(document, attributes);
        } else {
            throw new PrintNotSupported(PrintMessages.unsupportedDocument(document.getName(), this.printService.getName()));
        }
    }

    protected Document getDecompressedDocument(Document document) {
        if (!(document instanceof CompressedDocumentImpl)) {
            document = new CompressedDocumentImpl(document, this.handlers);
        }
        return document;
    }

    private void printDocument(Document document, PrintAttributes attributes) {
        try {
            DocFlavor.INPUT_STREAM flavor = new DocFlavor.INPUT_STREAM(document.getMimeType());
            SimpleDoc doc = new SimpleDoc(document.getContent(), flavor, null);
            DocPrintJob job = this.printService.createPrintJob();
            job.print(doc, this.createAttributes(attributes));
        }
        catch (Throwable exception) {
            throw new PrinterException(PrintMessages.failedToPrintDocument(document.getName(), this.printService.getName(), exception.getMessage()), exception);
        }
    }

    private void printPDF(Document document, PrintAttributes attributes) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(this.printService);
            try (PDDocument pdf = PDDocument.load((InputStream)document.getContent());){
                job.setPageable((Pageable)new PDFPageable(pdf));
                job.print(this.createAttributes(attributes));
            }
        }
        catch (Exception exception) {
            throw new PrinterException(PrintMessages.failedToPrintDocument(document.getName(), this.printService.getName(), exception.getMessage()), (Throwable)exception);
        }
    }

    private PrintRequestAttributeSet createAttributes(PrintAttributes attributes) {
        HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
        if (attributes.getMediaSize() != null) {
            set.add(attributes.getMediaSize());
        }
        if (attributes.getOrientation() != null) {
            set.add(attributes.getOrientation());
        }
        if (attributes.getMediaTray() != null) {
            set.add(attributes.getMediaTray());
        }
        set.add(new Copies(attributes.getCopies()));
        if (attributes.getSides() != null) {
            set.add(attributes.getSides());
        }
        return set;
    }

    private boolean supports(String mimeType) {
        return this.printService.isDocFlavorSupported(new DocFlavor(mimeType, InputStream.class.getName()));
    }
}

