/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.security;

import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.security.AuthenticationContext;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.user.User;

public class RunAsService {
    private final PracticeService practiceService;
    private final AuthenticationContext context;

    public RunAsService(AuthenticationContext context, PracticeService practiceService) {
        this.context = context;
        this.practiceService = practiceService;
    }

    public void run(Runnable runnable) {
        User user = this.context.getUser();
        if (user != null) {
            runnable.run();
        } else {
            RunAs.run((User)this.getUser(), (Runnable)runnable);
        }
    }

    private User getUser() {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            throw new IllegalStateException("The Service User has not been configured on the Practice");
        }
        return user;
    }
}

