/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.mapping.exception.MappingException;
import org.openvpms.mapping.model.Cardinality;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Source;
import org.openvpms.mapping.model.Target;
import org.openvpms.mapping.model.Targets;
import org.openvpms.plugin.internal.service.mapping.IMObjectMapping;
import org.openvpms.plugin.internal.service.mapping.SourceImpl;
import org.openvpms.plugin.service.i18n.MappingMessages;

class MappingsImpl<T extends IMObject>
implements Mappings<T> {
    private final IMObjectBean config;
    private final Class<T> type;
    private final String sourceArchetype;
    private final String displayName;
    private final String sourceDisplayName;
    private final Targets targets;
    private final Map<String, List<Mapping>> bySource = new LinkedHashMap<String, List<Mapping>>();
    private final Map<String, List<Mapping>> byTarget = new HashMap<String, List<Mapping>>();
    private final Cardinality cardinality;
    private final ArchetypeService service;

    MappingsImpl(IMObject config, Class<T> type, String sourceArchetype, String displayName, String sourceDisplayName, Targets targets, ArchetypeService service) {
        this.config = service.getBean(config);
        this.type = type;
        this.sourceArchetype = sourceArchetype;
        this.displayName = displayName;
        this.sourceDisplayName = sourceDisplayName;
        this.targets = targets;
        this.service = service;
        this.cardinality = this.getCardinality(this.config);
        for (Relationship relationship : this.config.getValues("mappings", Relationship.class)) {
            Reference source = relationship.getTarget();
            if (source == null || !source.isA(sourceArchetype)) continue;
            Target target = this.getTarget(service.getBean((IMObject)relationship));
            Mapping mapping = this.createMapping((IMObject)relationship, source, target);
            this.add(mapping);
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public String getTargetDisplayName() {
        return this.targets.getDisplayName();
    }

    public List<Mapping> getMappings() {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (List<Mapping> mappings : this.bySource.values()) {
            result.addAll(mappings);
        }
        return result;
    }

    public Mapping getMapping(T source) {
        return this.getMapping(source.getObjectReference());
    }

    public Mapping getMapping(Reference source) {
        List<Mapping> mappings = this.bySource.get(this.toString(source));
        return mappings != null && !mappings.isEmpty() ? mappings.get(0) : null;
    }

    public Mapping getMapping(String target) {
        List<Mapping> mappings = this.getMappings(target);
        return !mappings.isEmpty() ? mappings.get(0) : null;
    }

    public List<Mapping> getMappings(String target) {
        List<Mapping> mappings = this.byTarget.get(target);
        return mappings != null ? mappings : Collections.emptyList();
    }

    public Mapping add(T source, Target target) {
        if (!source.isA(this.sourceArchetype)) {
            throw new MappingException(MappingMessages.invalidArchetype((String)source.getArchetype(), (String)this.sourceArchetype));
        }
        Relationship relationship = this.config.addTarget("mappings", source);
        this.updateRelationship(relationship, target);
        Mapping mapping = this.createMapping((IMObject)relationship, source.getObjectReference(), target);
        this.add(mapping);
        return mapping;
    }

    public void replace(Mapping mapping, T source, Target target) {
        if (!(mapping instanceof IMObjectMapping)) {
            throw new IllegalArgumentException("Unsupported mapping: " + mapping);
        }
        this.remove(mapping.getSource(), mapping.getTarget());
        IMObjectMapping impl = (IMObjectMapping)mapping;
        Relationship relationship = (Relationship)impl.getConfig();
        relationship.setTarget(source.getObjectReference());
        this.updateRelationship(relationship, target);
        impl.setSource(source.getObjectReference());
        impl.setTarget(target);
        this.add(impl);
    }

    public void remove(Mapping mapping) {
        this.remove(mapping.getSource(), mapping.getTarget());
        IMObject relationship = ((IMObjectMapping)mapping).getConfig();
        this.config.removeValue("mappings", relationship);
    }

    public void save() {
        for (Map.Entry<String, List<Mapping>> entry : this.bySource.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Mapping mapping = entry.getValue().get(0);
            Reference source = mapping.getSource();
            String name = this.getName(source);
            throw new MappingException(MappingMessages.multipleMappingsExistForSource((long)source.getId(), (String)name));
        }
        if (this.getCardinality() == Cardinality.ONE_TO_ONE) {
            for (Map.Entry<String, List<Mapping>> entry : this.byTarget.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                Mapping mapping = entry.getValue().get(0);
                Target target = mapping.getTarget();
                throw new MappingException(MappingMessages.multipleMappingsExistForTarget((String)target.getId(), (String)target.getName()));
            }
        }
        this.config.save();
    }

    public Reference getSource(String target) {
        Mapping mapping = this.getMapping(target);
        return mapping != null ? mapping.getSource() : null;
    }

    public Target getTarget(T source) {
        return this.getTarget(source.getObjectReference());
    }

    public Target getTarget(Reference source) {
        Mapping mapping = this.getMapping(source);
        return mapping != null ? mapping.getTarget() : null;
    }

    public Target getTarget(String target) {
        return this.targets.getTarget(target);
    }

    public int getTargetCount(String name, boolean unmapped) {
        return this.targets.count((Mappings)this, name, unmapped);
    }

    public List<Source> getSources(String name, boolean unmapped, int firstResult, int maxResults) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createTupleQuery();
        Root root = query.from(this.type, new String[]{this.sourceArchetype});
        Path idPath = root.get("id").alias("id");
        Path namePath = root.get("name").alias("name");
        query.multiselect(new Selection[]{idPath, namePath});
        this.addConstraints(query, root, name, (Path<String>)namePath, unmapped, builder);
        query.orderBy(new Order[]{builder.asc((Expression)namePath), builder.asc((Expression)idPath)});
        ArrayList<Source> result = new ArrayList<Source>();
        TypedQuery typedQuery = this.service.createQuery(query);
        typedQuery.setFirstResult(firstResult);
        typedQuery.setMaxResults(maxResults);
        for (Tuple tuple : typedQuery.getResultList()) {
            IMObjectReference reference = new IMObjectReference(this.sourceArchetype, ((Long)tuple.get("id", Long.class)).longValue());
            result.add(new SourceImpl((Reference)reference, (String)tuple.get("name", String.class)));
        }
        return result;
    }

    public long getSourceCount(String name, boolean unmapped) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(this.type, new String[]{this.sourceArchetype});
        query.select((Selection)builder.count((Expression)root));
        this.addConstraints(query, root, name, null, unmapped, builder);
        long result = (Long)this.service.createQuery(query).getSingleResult();
        return (int)result;
    }

    public List<Target> getTargets(String name, boolean unmapped, int firstResult, int maxResults) {
        return this.targets.getTargets((Mappings)this, name, unmapped, firstResult, maxResults);
    }

    private String getName(Reference reference) {
        IMObject object = this.service.get(reference);
        return object != null ? object.getName() : "<unknown>";
    }

    private Cardinality getCardinality(IMObjectBean config) {
        String value = config.getString("cardinality");
        return "N:1".equals(value) ? Cardinality.MANY_TO_ONE : Cardinality.ONE_TO_ONE;
    }

    private String toString(Reference source) {
        return source.getArchetype() + ":" + source.getId();
    }

    private void add(Mapping mapping) {
        Reference source = mapping.getSource();
        Target target = mapping.getTarget();
        List sources = this.bySource.computeIfAbsent(this.toString(source), k -> new ArrayList());
        sources.add(mapping);
        List targets = this.byTarget.computeIfAbsent(target.getId(), k -> new ArrayList());
        targets.add(mapping);
    }

    private void remove(Reference source, Target target) {
        List<Mapping> targets;
        List<Mapping> sources = this.bySource.get(this.toString(source));
        if (sources != null) {
            sources.removeIf(mapping -> Objects.equals(target.getId(), mapping.getTarget().getId()));
        }
        if ((targets = this.byTarget.get(target.getId())) != null) {
            targets.removeIf(mapping -> Objects.equals(source, mapping.getSource()));
        }
    }

    private Mapping createMapping(IMObject config, Reference source, Target target) {
        return new IMObjectMapping(config, source, target);
    }

    private void updateRelationship(Relationship relationship, Target target) {
        IMObjectBean mapping = this.service.getBean((IMObject)relationship);
        relationship.setActive(target.isActive());
        mapping.setValue("identity", (Object)target.getId());
        mapping.setValue("description", (Object)target.getName());
    }

    private Target getTarget(IMObjectBean bean) {
        return this.targets.create(bean.getString("identity"), bean.getString("description"), bean.getObject().isActive());
    }

    private void addConstraints(CriteriaQuery<?> query, Root<T> root, String name, Path<String> namePath, boolean unmapped, CriteriaBuilder builder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("active"), (Object)true));
        if (name != null) {
            if (namePath == null) {
                namePath = root.get("name").alias(name);
            }
            predicates.add(builder.like(namePath, name));
        }
        if (unmapped) {
            IMObject object = this.config.getObject();
            Root mappingRoot = query.from(object.getClass(), new String[]{object.getArchetype()});
            Join mappings = mappingRoot.join("mappings");
            mappings.on((Expression)builder.equal((Expression)mappings.get("target"), (Expression)root.reference()));
        }
        query.where(predicates);
    }
}

