/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.mapping;

import java.util.Comparator;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.mapping.exception.MappingException;
import org.openvpms.mapping.model.Cardinality;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Targets;
import org.openvpms.mapping.service.MappingService;
import org.openvpms.plugin.internal.service.mapping.MappingsImpl;
import org.openvpms.plugin.service.i18n.MappingMessages;

public class MappingServiceImpl
implements MappingService {
    private final ArchetypeService service;

    public MappingServiceImpl(ArchetypeService service) {
        this.service = service;
    }

    public <T extends IMObject> IMObject createMappingConfiguration(Class<T> type) {
        IMObject result;
        if (Entity.class.isAssignableFrom(type)) {
            result = this.service.create("entity.entityMappings", Entity.class);
        } else if (Lookup.class.isAssignableFrom(type)) {
            result = this.service.create("lookup.lookupMappings", Lookup.class);
            Lookup lookup = (Lookup)result;
            lookup.setCode(result.getLinkId().toUpperCase());
        } else {
            throw new MappingException(MappingMessages.unsupportedType(type));
        }
        return result;
    }

    public <T extends IMObject> IMObject createMappingConfiguration(Class<T> type, Cardinality cardinality) {
        IMObject object = this.createMappingConfiguration(type);
        this.setCardinality(object, cardinality);
        return object;
    }

    public Lookup getMappingConfiguration(String code, boolean create, Cardinality cardinality) {
        String archetype = "lookup.lookupMappings";
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Lookup.class);
        Root from = query.from(Lookup.class, new String[]{archetype});
        query.where((Expression)builder.equal((Expression)from.get("code"), (Object)code));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        Lookup result = (Lookup)this.service.createQuery(query).getFirstResult();
        if (result == null) {
            result = (Lookup)this.service.create(archetype, Lookup.class);
            result.setCode(code);
            if (cardinality != null) {
                this.setCardinality((IMObject)result, cardinality);
            }
            this.service.save((IMObject)result);
        }
        return result;
    }

    public <T extends IMObject> Mappings<T> createMappings(IMObject config, Class<T> type, String archetype, String displayName, Targets targets) {
        String sourceDisplayName;
        List<ArchetypeDescriptor> descriptors = this.checkArchetype(archetype, type);
        if (descriptors.size() > 1) {
            descriptors.sort(Comparator.comparing(ArchetypeDescriptor::getDisplayName));
            sourceDisplayName = descriptors.get(0).getDisplayName();
            sourceDisplayName = sourceDisplayName + ",...";
        } else {
            sourceDisplayName = descriptors.get(0).getDisplayName();
        }
        return new MappingsImpl<T>(config, type, archetype, displayName, sourceDisplayName, targets, this.service);
    }

    public <T extends IMObject> Mappings<T> createMappings(IMObject config, Class<T> type, String archetype, String displayName, String sourceDisplayName, Targets targets) {
        this.checkArchetype(archetype, type);
        return new MappingsImpl<T>(config, type, archetype, displayName, sourceDisplayName, targets, this.service);
    }

    private void setCardinality(IMObject config, Cardinality cardinality) {
        IMObjectBean bean = this.service.getBean(config);
        switch (cardinality) {
            case ONE_TO_ONE: {
                bean.setValue("cardinality", (Object)"1:1");
                break;
            }
            case MANY_TO_ONE: {
                bean.setValue("cardinality", (Object)"N:1");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported cardinality: " + cardinality);
            }
        }
    }

    private <T extends IMObject> List<ArchetypeDescriptor> checkArchetype(String archetype, Class<T> type) {
        if (!Entity.class.isAssignableFrom(type) && !Lookup.class.isAssignableFrom(type)) {
            throw new MappingException(MappingMessages.unsupportedType(type));
        }
        List descriptors = this.service.getArchetypeDescriptors(archetype);
        if (descriptors.isEmpty()) {
            throw new MappingException(MappingMessages.archetypeNotFound((String)archetype));
        }
        for (ArchetypeDescriptor descriptor : descriptors) {
            if (type.isAssignableFrom(descriptor.getClassType())) continue;
            throw new MappingException(MappingMessages.archetypeNotType((String)descriptor.getArchetypeType(), type));
        }
        return descriptors;
    }
}

