/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.archetype;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.plugin.manager.PluginManagerListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class IMObjectUpdateNotifier<T>
implements InitializingBean,
DisposableBean {
    private final PluginManagerListener pluginManagerListener;
    private final Class<T> type;
    private final IArchetypeService service;
    private final PluginManager manager;
    private final ScheduledExecutorService executor;
    private final AtomicLong counter = new AtomicLong(0L);
    private final Map<T, Listener> listeners = Collections.synchronizedMap(new HashMap());
    private volatile ServiceTracker<T, T> tracker;
    private static final Logger log = LoggerFactory.getLogger(IMObjectUpdateNotifier.class);

    public IMObjectUpdateNotifier(Class<T> type, IArchetypeService service, PluginManager manager) {
        this.type = type;
        this.pluginManagerListener = new PluginManagerListener(){

            public void started() {
                IMObjectUpdateNotifier.this.onStart();
            }

            public void stopped() {
            }
        };
        this.service = service;
        this.manager = manager;
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "IMObjectUpdateNotifier" + this.counter.incrementAndGet()));
    }

    public void afterPropertiesSet() {
        this.manager.addListener(this.pluginManagerListener);
    }

    public void destroy() {
        Listener[] listeners;
        for (Listener listener : listeners = (Listener[])Iterables.toArray(this.listeners.values(), Listener.class)) {
            try {
                listener.unregister(this.service);
            }
            catch (Exception exception) {
                log.warn("Failed to unregister listener for archetypes=" + StringUtils.join((Object[])listener.archetypes, (char)','));
            }
        }
        try {
            this.executor.shutdown();
        }
        catch (Exception exception) {
            log.error("Failed to shutdown Executor: {}", (Object)exception.getMessage(), (Object)exception);
        }
        try {
            ServiceTracker<T, T> tracker = this.tracker;
            if (tracker != null) {
                tracker.close();
            }
        }
        catch (Exception exception) {
            log.error("Warning: failed to close ServiceTracker: {}", (Object)exception.getMessage(), (Object)exception);
        }
        this.manager.removeListener(this.pluginManagerListener);
    }

    protected abstract Listener createListener(T var1);

    protected IArchetypeService getService() {
        return this.service;
    }

    protected void addService(T service) {
        try {
            Listener listener = this.createListener(service);
            this.listeners.put(service, listener);
            listener.register(this.service);
        }
        catch (Exception exception) {
            log.warn("Failed to add {}", service.getClass(), (Object)exception);
        }
    }

    protected void removeService(T service) {
        Listener listener = this.listeners.remove(service);
        if (listener != null) {
            listener.unregister(this.service);
        }
    }

    private void onStart() {
        BundleContext bundleContext = this.manager.getBundleContext();
        if (bundleContext != null) {
            this.tracker = this.getServiceTracker(bundleContext);
            this.tracker.open();
        } else {
            log.error("Cannot start IMObjectUpdateNotifier for {}: no BundleContext", this.type);
        }
    }

    private ServiceTracker<T, T> getServiceTracker(BundleContext bundleContext) {
        return new ServiceTracker<T, T>(bundleContext, this.type, null){

            public T addingService(ServiceReference<T> reference) {
                Object service = super.addingService(reference);
                if (service != null) {
                    IMObjectUpdateNotifier.this.addService(service);
                }
                return service;
            }

            public void removedService(ServiceReference<T> reference, T service) {
                IMObjectUpdateNotifier.this.removeService(service);
                super.removedService(reference, service);
            }
        };
    }

    protected class Listener {
        private final String[] archetypes;
        private final IArchetypeServiceListener delegate;

        public Listener(String[] archetypes, final IArchetypeServiceListener listener) {
            this.archetypes = archetypes;
            this.delegate = new IArchetypeServiceListener(){

                public void save(IMObject object) {
                    IMObjectUpdateNotifier.this.executor.execute(() -> listener.save(object));
                }

                public void remove(IMObject object) {
                    IMObjectUpdateNotifier.this.executor.execute(() -> listener.remove(object));
                }

                public void saved(IMObject object) {
                    IMObjectUpdateNotifier.this.executor.execute(() -> listener.saved(object));
                }

                public void removed(IMObject object) {
                    IMObjectUpdateNotifier.this.executor.execute(() -> listener.removed(object));
                }

                public void rollback(IMObject object) {
                    IMObjectUpdateNotifier.this.executor.execute(() -> listener.rollback(object));
                }
            };
        }

        private void register(IArchetypeService service) {
            for (String archetype : this.archetypes) {
                service.addListener(archetype, this.delegate);
            }
        }

        private void unregister(IArchetypeService service) {
            for (String archetype : this.archetypes) {
                service.removeListener(archetype, this.delegate);
            }
        }
    }
}

