/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.archetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.openvpms.tools.archetype.loader.ArchetypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ArchetypeInstallerImpl
implements ArchetypeInstaller {
    private final ArchetypeService service;
    private final ArchetypeLoader loader;
    private final PlatformTransactionManager txnManager;
    private static final Logger log = LoggerFactory.getLogger(ArchetypeInstallerImpl.class);

    public ArchetypeInstallerImpl(ArchetypeService service, PlatformTransactionManager txnManager) {
        this.service = service;
        this.txnManager = txnManager;
        this.loader = new ArchetypeLoader(service);
    }

    public void install(InputStream stream) {
        List<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.read(stream);
        this.install(descriptors);
    }

    public void install(String path) {
        this.install(new String[]{path});
    }

    public void install(String ... paths) {
        List<org.openvpms.component.model.archetype.ArchetypeDescriptor> list = this.read(paths);
        this.install(list);
    }

    public void install(Class<?> type, String path) {
        this.install(type, new String[]{path});
    }

    public void install(Class<?> type, String ... paths) {
        ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        for (String path : paths) {
            try (InputStream stream = type.getResourceAsStream(path);){
                if (stream == null) {
                    throw new IllegalStateException("No archetype at path: " + path);
                }
                descriptors.addAll(this.read(stream));
            }
            catch (IOException exception) {
                throw new IllegalStateException("Failed to read archetype at path: " + path, exception);
            }
        }
        if (!descriptors.isEmpty()) {
            this.install(descriptors);
        }
    }

    private void install(final List<org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors) {
        TransactionTemplate template = new TransactionTemplate(this.txnManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : descriptors) {
                    ArchetypeInstallerImpl.this.loader.loadArchetype(descriptor);
                }
            }
        });
    }

    private List<org.openvpms.component.model.archetype.ArchetypeDescriptor> read(String[] paths) {
        ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor> list = new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        for (String path : paths) {
            ArchetypeDescriptors descriptors = this.getArchetypeDescriptors(path);
            this.validateAll(descriptors, list);
        }
        return list;
    }

    private List<org.openvpms.component.model.archetype.ArchetypeDescriptor> read(InputStream stream) {
        ArchetypeDescriptors descriptors = ArchetypeDescriptors.read((InputStream)stream);
        return this.validateAll(descriptors, new ArrayList<org.openvpms.component.model.archetype.ArchetypeDescriptor>());
    }

    private List<org.openvpms.component.model.archetype.ArchetypeDescriptor> validateAll(ArchetypeDescriptors descriptors, List<org.openvpms.component.model.archetype.ArchetypeDescriptor> list) {
        for (ArchetypeDescriptor descriptor : descriptors.getArchetypeDescriptorsAsArray()) {
            this.service.validate((IMObject)descriptor);
            list.add((org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArchetypeDescriptors getArchetypeDescriptors(String path) {
        FileSystemResource resource = new FileSystemResource(path);
        if (!resource.exists()) {
            resource = new ClassPathResource(path);
        }
        log.info("Reading archetypes from " + resource.getDescription());
        try (InputStream stream = resource.getInputStream();){
            ArchetypeDescriptors archetypeDescriptors = ArchetypeDescriptors.read((InputStream)stream);
            return archetypeDescriptors;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Could not read archetype descriptor: " + path, exception);
        }
    }
}

