/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.config;

import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.plugin.internal.service.archetype.IMObjectUpdateNotifier;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.plugin.service.config.ConfigurableService;

public class PluginConfigurationService
extends IMObjectUpdateNotifier<ConfigurableService> {
    public PluginConfigurationService(IArchetypeService service, PluginManager manager) {
        super(ConfigurableService.class, service, manager);
    }

    @Override
    protected void addService(ConfigurableService service) {
        super.addService(service);
    }

    @Override
    protected void removeService(ConfigurableService service) {
        super.removeService(service);
    }

    @Override
    protected IMObjectUpdateNotifier.Listener createListener(final ConfigurableService service) {
        String archetype = service.getArchetype();
        if (archetype.contains("*")) {
            throw new IllegalStateException(ConfigurableService.class.getSimpleName() + " archetypes cannot contain wildcards: " + archetype);
        }
        AbstractArchetypeServiceListener delegate = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                PluginConfigurationService.this.onSaved(object, service);
            }

            public void removed(IMObject object) {
                PluginConfigurationService.this.onRemoved(object, service);
            }
        };
        IMObject config = this.getConfig(archetype);
        service.setConfiguration(config);
        String[] archetypes = new String[]{archetype};
        return new IMObjectUpdateNotifier.Listener(archetypes, (IArchetypeServiceListener)delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSaved(IMObject object, ConfigurableService service) {
        boolean inactive = false;
        ConfigurableService configurableService = service;
        synchronized (configurableService) {
            IMObject current = service.getConfiguration();
            if (current == null || current.getId() == object.getId() && current.getVersion() <= object.getVersion()) {
                if (object.isActive()) {
                    service.setConfiguration(object);
                } else {
                    inactive = true;
                }
            }
        }
        if (inactive) {
            IMObject config = this.getConfig(object.getArchetype());
            ConfigurableService configurableService2 = service;
            synchronized (configurableService2) {
                IMObject current = service.getConfiguration();
                if (current == null || object.getId() == current.getId()) {
                    service.setConfiguration(config);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemoved(IMObject object, ConfigurableService service) {
        ConfigurableService configurableService = service;
        synchronized (configurableService) {
            IMObject current = service.getConfiguration();
            if (current != null && current.getId() == object.getId()) {
                service.setConfiguration(this.getConfig(object.getArchetype()));
            }
        }
    }

    private IMObject getConfig(String archetype) {
        ArchetypeQuery query = new ArchetypeQuery(archetype, true);
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query);
        return iterator.hasNext() ? (IMObject)iterator.next() : null;
    }
}

