/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.service.archetype;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.DelegatingArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.AssertionTypeDescriptor;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.component.service.lookup.LookupService;

public class PluginArchetypeService
implements ArchetypeService {
    private final IArchetypeService service;
    private final LookupService lookups;
    private final PracticeService practiceService;
    private final IArchetypeService writable;

    public PluginArchetypeService(IArchetypeRuleService service, LookupService lookups, PracticeService practiceService) {
        this.service = service;
        this.lookups = lookups;
        this.practiceService = practiceService;
        this.writable = new DelegatingArchetypeService((IArchetypeService)service){

            public void save(org.openvpms.component.model.object.IMObject object) {
                PluginArchetypeService.this.save(object);
            }

            public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
                PluginArchetypeService.this.save(objects);
            }

            public IMObject create(String shortName) {
                return (IMObject)PluginArchetypeService.this.create(shortName);
            }

            public <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
                return PluginArchetypeService.this.create(archetype, type);
            }
        };
    }

    public List<String> getArchetypes(String archetype, boolean primaryOnly) {
        return this.service.getArchetypes(archetype, primaryOnly);
    }

    public ArchetypeDescriptor getArchetypeDescriptor(String archetype) {
        return this.service.getArchetypeDescriptor(archetype);
    }

    public List<ArchetypeDescriptor> getArchetypeDescriptors(String archetype) {
        return this.service.getArchetypeDescriptors(archetype);
    }

    public List<ArchetypeDescriptor> getArchetypeDescriptors() {
        return this.service.getArchetypeDescriptors();
    }

    public AssertionTypeDescriptor getAssertionTypeDescriptor(String name) {
        return this.service.getAssertionTypeDescriptor(name);
    }

    public List<AssertionTypeDescriptor> getAssertionTypeDescriptors() {
        return this.service.getAssertionTypeDescriptors();
    }

    public IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return new IMObjectBean(object, this.writable, this.lookups);
    }

    public org.openvpms.component.model.object.IMObject create(String archetype) {
        return this.create(archetype, org.openvpms.component.model.object.IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
        return (T)this.run(() -> this.service.create(archetype, type));
    }

    public void deriveValues(org.openvpms.component.model.object.IMObject object) {
        this.run(() -> this.service.deriveValues(object));
    }

    public void deriveValue(org.openvpms.component.model.object.IMObject object, String node) {
        this.run(() -> this.service.deriveValue(object, node));
    }

    public void save(org.openvpms.component.model.object.IMObject object) {
        this.run(() -> this.service.save(object));
    }

    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
        this.run(() -> this.service.save(objects));
    }

    public void remove(org.openvpms.component.model.object.IMObject object) {
        this.run(() -> this.service.remove(object));
    }

    public void remove(Reference reference) {
        this.run(() -> this.service.remove(reference));
    }

    public List<ValidationError> validate(org.openvpms.component.model.object.IMObject object) {
        return this.service.validate(object);
    }

    public org.openvpms.component.model.object.IMObject get(Reference reference) {
        return this.service.get(reference);
    }

    public org.openvpms.component.model.object.IMObject get(Reference reference, boolean active) {
        return this.service.get(reference, active);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(Reference reference, Class<T> type) {
        return (T)this.service.get(reference, type);
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id) {
        return this.service.get(archetype, id);
    }

    public org.openvpms.component.model.object.IMObject get(String archetype, long id, boolean active) {
        return this.service.get(archetype, id, active);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T get(String archetype, long id, Class<T> type) {
        return (T)this.service.get(archetype, id, type);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.service.getCriteriaBuilder();
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> query) {
        return this.service.createQuery(query);
    }

    private void run(Runnable runnable) {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            throw new IllegalStateException("Cannot invoke ArchetypeService operation as no Service User has been configured");
        }
        RunAs.run((User)user, (Runnable)runnable);
    }

    private <T> T run(Supplier<T> supplier) {
        User user = this.practiceService.getServiceUser();
        if (user == null) {
            throw new IllegalStateException("Cannot invoke ArchetypeService operation as no Service User has been configured");
        }
        return (T)RunAs.call((User)user, supplier);
    }
}

