/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.atlassian;

import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.plugin.internal.manager.ServletContainerContext;
import org.openvpms.version.Version;

public class ApplicationPropertiesImpl
implements ApplicationProperties {
    private final WebResourceIntegration webResourceIntegration;
    private final ServletContainerContext context;
    private final PracticeService practiceService;
    private final Supplier<String> canonicalBaseUrlSupplier = this::getCanonicalBaseUrl;
    private final Supplier<String> canonicalContextPathSupplier = this::getCanonicalContextPath;

    public ApplicationPropertiesImpl(WebResourceIntegration webResourceIntegration, ServletContainerContext context, PracticeService practiceService) {
        this.webResourceIntegration = webResourceIntegration;
        this.context = context;
        this.practiceService = practiceService;
    }

    public String getBaseUrl() {
        return this.webResourceIntegration.getBaseUrl();
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case ABSOLUTE: {
                Optional<String> absoluteUrl = this.getAbsoluteBaseUrlFromRequest();
                return absoluteUrl.orElseGet(this.canonicalBaseUrlSupplier);
            }
            case CANONICAL: {
                return this.getCanonicalBaseUrl();
            }
            case RELATIVE: {
                Optional<String> contextPath = this.getContextPathFromRequest();
                return contextPath.orElseGet(this.canonicalContextPathSupplier);
            }
            case RELATIVE_CANONICAL: {
                return this.getCanonicalContextPath();
            }
            case AUTO: {
                Optional<String> contextPath = this.getContextPathFromRequest();
                return contextPath.orElseGet(this.canonicalBaseUrlSupplier);
            }
        }
        throw new IllegalStateException("Unhandled UrlMode " + urlMode);
    }

    public String getDisplayName() {
        return "OpenVPMS";
    }

    public String getPlatformId() {
        return "openvpms";
    }

    public String getVersion() {
        return Version.VERSION;
    }

    public Date getBuildDate() {
        return new Date();
    }

    public String getBuildNumber() {
        return Version.REVISION;
    }

    public File getHomeDirectory() {
        return null;
    }

    public String getPropertyValue(String var1) {
        return null;
    }

    private Optional<String> getAbsoluteBaseUrlFromRequest() {
        HttpServletRequest request = this.context.getRequest();
        if (request != null) {
            return Optional.of(this.webResourceIntegration.getBaseUrl(com.atlassian.plugin.webresource.UrlMode.ABSOLUTE));
        }
        return Optional.empty();
    }

    private Optional<String> getContextPathFromRequest() {
        HttpServletRequest request = this.context.getRequest();
        if (request != null) {
            return Optional.of(request.getContextPath());
        }
        return Optional.empty();
    }

    private String getCanonicalBaseUrl() {
        String result = this.practiceService.getBaseURL();
        if (result == null) {
            throw new IllegalStateException("Practice Base URL is not configured");
        }
        return StringUtils.removeEnd((String)result, (String)"/");
    }

    private String getCanonicalContextPath() {
        String baseUrl = this.getCanonicalBaseUrl();
        try {
            return new URL(baseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL misconfigured", e);
        }
    }
}

