/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.hostcontainer.SimpleConstructorHostContainer;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.store.MemoryPluginPersistentStateStore;
import com.atlassian.plugin.module.ClassPrefixModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.module.PrefixModuleFactory;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.module.BeanPrefixModuleFactory;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.impl.DefaultDescribedModuleDescriptorFactory;
import com.atlassian.plugin.scope.EverythingIsActiveScopeManager;
import com.atlassian.plugin.scope.ScopeManager;
import com.atlassian.plugin.servlet.DefaultServletModuleManager;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletContextListenerModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletContextParamModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.PluginResourceLocatorImpl;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.WebResourceUrlProviderImpl;
import com.atlassian.plugin.webresource.assembler.DefaultPageBuilderService;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.xsrf.XsrfRequestValidator;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.sal.core.message.SystemDefaultLocaleResolver;
import com.atlassian.sal.core.net.HttpClientRequestFactory;
import com.atlassian.sal.core.xsrf.IndependentXsrfTokenAccessor;
import com.atlassian.sal.core.xsrf.IndependentXsrfTokenValidator;
import com.atlassian.sal.core.xsrf.XsrfRequestValidatorImpl;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.plugin.internal.manager.AtlassianPlugins;
import org.openvpms.plugin.internal.manager.ExportPackages;
import org.openvpms.plugin.internal.manager.ServletContainerContext;
import org.openvpms.plugin.internal.manager.atlassian.ApplicationPropertiesImpl;
import org.openvpms.plugin.internal.manager.atlassian.DarkFeatureManagerImpl;
import org.openvpms.plugin.internal.manager.atlassian.I18nResolverImpl;
import org.openvpms.plugin.internal.manager.atlassian.WebResourceIntegrationImpl;
import org.openvpms.plugin.internal.manager.atlassian.WebSudoManagerImpl;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.plugin.manager.PluginManagerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManagerImpl
implements PluginManager {
    private final Provider provider;
    private final PluginDAO pluginDAO;
    private final ServletContainerContext context;
    private final PracticeService practiceService;
    private final org.apache.felix.framework.Logger logger = new org.apache.felix.framework.Logger();
    private final Set<PluginManagerListener> listeners = Collections.synchronizedSet(new HashSet());
    private AtlassianPlugins plugins;
    private ServletModuleManager servletModuleManager;
    private static final Logger log = LoggerFactory.getLogger(PluginManagerImpl.class);

    PluginManagerImpl(HostComponentProvider provider, PluginDAO pluginDAO, ServletContainerContext context, PracticeService practiceService) {
        this.provider = new Provider(provider);
        this.pluginDAO = pluginDAO;
        this.context = context;
        this.practiceService = practiceService;
    }

    public <T> boolean hasService(Class<T> type) {
        BundleContext context = this.getBundleContext();
        return context != null && context.getServiceReference(type) != null;
    }

    public <T> T getService(Class<T> type) {
        ServiceReference reference;
        T result = null;
        BundleContext context = this.getBundleContext();
        if (context != null && (reference = context.getServiceReference(type)) != null) {
            result = this.getService(reference, context);
        }
        return result;
    }

    public <T> List<T> getServices(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        BundleContext context = this.getBundleContext();
        if (context != null) {
            try {
                Collection references = context.getServiceReferences(type, null);
                for (ServiceReference reference : references) {
                    T service = this.getService(reference, context);
                    if (service == null) continue;
                    result.add(service);
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    public synchronized BundleContext getBundleContext() {
        if (this.plugins != null) {
            Bundle[] bundles = this.plugins.getOsgiContainerManager().getBundles();
            return bundles[0].getBundleContext();
        }
        return null;
    }

    public Bundle[] getBundles() {
        BundleContext context = this.getBundleContext();
        return context != null ? context.getBundles() : new Bundle[]{};
    }

    public synchronized void start() {
        if (this.plugins == null) {
            File dir = this.getPluginDir("/WEB-INF/plugins");
            File system = this.getDir(dir, "system", false);
            File bundled = this.getDir(dir, "bundled", false);
            File deploy = this.getDir(dir, "deploy", true);
            File cache = this.getDir(dir, "cache", true);
            Bootstrapper bootstrapper = new Bootstrapper(system, bundled, deploy, cache);
            this.plugins = bootstrapper.getAlassianPlugins();
            this.servletModuleManager = bootstrapper.getServletModuleManager();
            this.plugins.afterPropertiesSet();
            this.plugins.getPluginSystemLifecycle().init();
            this.notifyStarted();
        }
    }

    public synchronized boolean isStarted() {
        return this.plugins != null;
    }

    public synchronized void stop() {
        if (this.plugins != null) {
            this.plugins.getPluginSystemLifecycle().shutdown();
            this.plugins.destroy();
            this.plugins = null;
            this.servletModuleManager = null;
            this.notifyStopped();
        }
    }

    public synchronized void install(File file) {
        JarPluginArtifact artifact = new JarPluginArtifact(file);
        this.plugins.getPluginController().installPlugins(new PluginArtifact[]{artifact});
    }

    public boolean canUninstall(Bundle bundle) {
        String key = this.getPluginKey(bundle);
        return this.pluginDAO.getPlugin(key) != null;
    }

    public synchronized void uninstall(Bundle bundle) throws BundleException {
        if (this.plugins == null) {
            throw new BundleException("PluginManager not running");
        }
        String key = this.getPluginKey(bundle);
        if (!this.pluginDAO.remove(key)) {
            throw new BundleException("Cannot uninstall plugin for key: " + key);
        }
        Plugin plugin = this.plugins.getPluginAccessor().getPlugin(key);
        if (plugin == null) {
            throw new BundleException("Plugin not found: " + key);
        }
        this.pluginDAO.remove(key);
        try {
            this.plugins.getPluginController().uninstall(plugin);
        }
        catch (PluginException exception) {
            throw new BundleException("Failed to uninstall bundle: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public synchronized boolean canRestart(Bundle bundle) {
        return this.plugins != null && this.plugins.getPluginAccessor().getPlugin(this.getPluginKey(bundle)) != null;
    }

    public synchronized void start(Bundle bundle) {
        if (this.canRestart(bundle)) {
            this.plugins.getPluginController().enablePlugins(new String[]{this.getPluginKey(bundle)});
        }
    }

    public synchronized void stop(Bundle bundle) {
        if (this.canRestart(bundle)) {
            this.plugins.getPluginController().disablePlugin(this.getPluginKey(bundle));
        }
    }

    public synchronized int scanForNewPlugins() {
        int result = 0;
        if (this.plugins != null) {
            result = this.plugins.getPluginController().scanForNewPlugins();
        }
        return result;
    }

    public void addListener(PluginManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PluginManagerListener listener) {
        this.listeners.remove(listener);
    }

    ServletModuleManager getServletModuleManager() {
        return this.servletModuleManager;
    }

    private String getPluginKey(Bundle bundle) {
        return OsgiHeaderUtil.getPluginKey((Bundle)bundle);
    }

    private <T> T getService(ServiceReference<T> reference, BundleContext context) {
        Object result = null;
        try {
            result = context.getService(reference);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        return (T)result;
    }

    private File getPluginDir(String path) {
        String realPath = this.context.getServletContext().getRealPath(path);
        File dir = new File(realPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalStateException("Invalid plugin directory: " + path);
        }
        return dir;
    }

    private File getDir(File parent, String path, boolean create) {
        File dir = new File(parent, path);
        if (!dir.exists()) {
            if (!create) {
                throw new IllegalArgumentException("Directory doesn't exist: " + dir);
            }
            if (!dir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create directory: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory: " + dir);
        }
        return dir;
    }

    private void notifyStarted() {
        PluginManagerListener[] list;
        for (PluginManagerListener listener : list = this.listeners.toArray(new PluginManagerListener[0])) {
            try {
                listener.started();
            }
            catch (Throwable exception) {
                log.error("PluginManagerListener threw exception", exception);
            }
        }
    }

    private void notifyStopped() {
        PluginManagerListener[] list;
        for (PluginManagerListener listener : list = this.listeners.toArray(new PluginManagerListener[0])) {
            try {
                listener.stopped();
            }
            catch (Throwable exception) {
                log.error("PluginManagerListener threw exception", exception);
            }
        }
    }

    private static class Provider
    implements HostComponentProvider {
        private final HostComponentProvider provider;
        private final Map<Object, Class<?>[]> objects = new HashMap<Object, Class<?>[]>();

        Provider(HostComponentProvider provider) {
            this.provider = provider;
        }

        public void provide(ComponentRegistrar registrar) {
            this.provider.provide(registrar);
            for (Map.Entry<Object, Class<?>[]> entry : this.objects.entrySet()) {
                registrar.register((Class[])entry.getValue()).forInstance(entry.getKey());
            }
        }

        void register(Object service, Class<?> ... interfaces) {
            this.objects.put(service, interfaces);
        }
    }

    private class Bootstrapper {
        private final AtlassianPlugins plugins;
        private final HostContainer hostContainer;
        private final ServletModuleManager servletModuleManager;

        Bootstrapper(File system, File bundled, File user, File cache) {
            URL bundledPluginUrl;
            ExportPackages exportPackages = ExportPackages.create(PluginManagerImpl.this.logger);
            HostContainer delegatingHostContainer = new HostContainer(){

                public <T> T create(Class<T> moduleClass) throws IllegalArgumentException {
                    return (T)Bootstrapper.this.hostContainer.create(moduleClass);
                }
            };
            DefaultDescribedModuleDescriptorFactory moduleDescriptorFactory = new DefaultDescribedModuleDescriptorFactory(delegatingHostContainer);
            moduleDescriptorFactory.addModuleDescriptor("servlet", ServletModuleDescriptor.class);
            moduleDescriptorFactory.addModuleDescriptor("servlet-filter", ServletFilterModuleDescriptor.class);
            moduleDescriptorFactory.addModuleDescriptor("servlet-context-param", ServletContextParamModuleDescriptor.class);
            moduleDescriptorFactory.addModuleDescriptor("servlet-context-listener", ServletContextListenerModuleDescriptor.class);
            moduleDescriptorFactory.addModuleDescriptor("web-resource", WebResourceModuleDescriptor.class);
            DefaultPackageScannerConfiguration scannerConfig = new DefaultPackageScannerConfiguration();
            scannerConfig.setServletContext(PluginManagerImpl.this.context.getServletContext());
            scannerConfig.setPackageVersions(exportPackages.getPackages());
            ArrayList<String> packageIncludes = new ArrayList<String>(exportPackages.getPackageIncludes());
            packageIncludes.addAll(scannerConfig.getPackageIncludes());
            scannerConfig.setPackageIncludes(packageIncludes);
            scannerConfig.setJarIncludes(exportPackages.getJarIncludes());
            scannerConfig.setJarExcludes(exportPackages.getJarExcludes());
            try {
                bundledPluginUrl = bundled.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException("Failed to get URL for bundled plugin directory: " + bundled, exception);
            }
            PluginsConfiguration config = new PluginsConfigurationBuilder().frameworkBundleDirectory(system).bundledPluginCacheDirectory(bundled).bundledPluginUrl(bundledPluginUrl).pluginDirectory(user).moduleDescriptorFactory((ModuleDescriptorFactory)moduleDescriptorFactory).packageScannerConfiguration((PackageScannerConfiguration)scannerConfig).hostComponentProvider((HostComponentProvider)PluginManagerImpl.this.provider).osgiPersistentCache(cache).pluginStateStore((PluginPersistentStateStore)new MemoryPluginPersistentStateStore()).build();
            this.plugins = new AtlassianPlugins(config, PluginManagerImpl.this.pluginDAO);
            PrefixDelegatingModuleFactory moduleFactory = new PrefixDelegatingModuleFactory(Collections.singleton(new BeanPrefixModuleFactory()));
            PluginEventManager pluginEventManager = this.plugins.getPluginEventManager();
            this.servletModuleManager = new DefaultServletModuleManager(PluginManagerImpl.this.context.getServletContext(), pluginEventManager);
            PluginAccessor pluginAccessor = this.plugins.getPluginAccessor();
            I18nResolverImpl i18nResolver = new I18nResolverImpl(pluginAccessor, pluginEventManager);
            WebResourceIntegrationImpl webResourceIntegration = new WebResourceIntegrationImpl(pluginAccessor, (LocaleResolver)new SystemDefaultLocaleResolver(), (I18nResolver)i18nResolver, pluginEventManager, PluginManagerImpl.this.context);
            WebResourceUrlProviderImpl webResourceUrlProvider = new WebResourceUrlProviderImpl((WebResourceIntegration)webResourceIntegration);
            ServletContextFactory servletContextFactory = PluginManagerImpl.this.context::getServletContext;
            PluginResourceLocatorImpl pluginResourceLocator = new PluginResourceLocatorImpl((WebResourceIntegration)webResourceIntegration, servletContextFactory, (WebResourceUrlProvider)webResourceUrlProvider, pluginEventManager);
            DefaultWebResourceAssemblerFactory prebakeWebResourceAssemblerFactory = new DefaultWebResourceAssemblerFactory((PluginResourceLocator)pluginResourceLocator);
            DefaultPageBuilderService pageBuilderService = new DefaultPageBuilderService((WebResourceIntegration)webResourceIntegration, (PrebakeWebResourceAssemblerFactory)prebakeWebResourceAssemblerFactory);
            EventPublisher eventPublisher = this.plugins.getEventPublisher();
            WebResourceManagerImpl webResourceManager = new WebResourceManagerImpl((PluginResourceLocator)pluginResourceLocator, (WebResourceIntegration)webResourceIntegration, (WebResourceUrlProvider)webResourceUrlProvider);
            System.setProperty("atlassian.org.osgi.framework.bootdelegation.extra", "META-INF");
            PluginManagerImpl.this.provider.register(eventPublisher, EventPublisher.class);
            PluginManagerImpl.this.provider.register((Object)i18nResolver, I18nResolver.class);
            PluginManagerImpl.this.provider.register(PluginManagerImpl.this.context, HttpContext.class);
            PluginManagerImpl.this.provider.register(webResourceIntegration, WebResourceIntegration.class);
            PluginManagerImpl.this.provider.register(webResourceUrlProvider, WebResourceUrlProvider.class);
            PluginManagerImpl.this.provider.register(webResourceManager, WebResourceManager.class);
            PluginManagerImpl.this.provider.register(this.servletModuleManager, ServletModuleManager.class);
            IndependentXsrfTokenAccessor accessor = new IndependentXsrfTokenAccessor();
            PluginManagerImpl.this.provider.register(accessor, XsrfTokenAccessor.class);
            IndependentXsrfTokenValidator xsrfTokenValidator = new IndependentXsrfTokenValidator((XsrfTokenAccessor)accessor);
            PluginManagerImpl.this.provider.register(xsrfTokenValidator, XsrfTokenValidator.class);
            PluginManagerImpl.this.provider.register(new XsrfRequestValidatorImpl((XsrfTokenValidator)xsrfTokenValidator), XsrfRequestValidator.class);
            PluginManagerImpl.this.provider.register(moduleFactory, ModuleFactory.class, DescribedModuleDescriptorFactory.class);
            PluginManagerImpl.this.provider.register(pageBuilderService, PageBuilderService.class);
            PluginManagerImpl.this.provider.register(pluginResourceLocator, PluginResourceLocator.class);
            PluginManagerImpl.this.provider.register(prebakeWebResourceAssemblerFactory, PrebakeWebResourceAssemblerFactory.class);
            PluginManagerImpl.this.provider.register(new HttpClientRequestFactory(), NonMarshallingRequestFactory.class);
            PluginManagerImpl.this.provider.register(new EverythingIsActiveScopeManager(), ScopeManager.class);
            PluginManagerImpl.this.provider.register(new ApplicationPropertiesImpl(webResourceIntegration, PluginManagerImpl.this.context, PluginManagerImpl.this.practiceService), ApplicationProperties.class);
            PluginManagerImpl.this.provider.register(new DarkFeatureManagerImpl(), DarkFeatureManager.class);
            PluginManagerImpl.this.provider.register(new WebSudoManagerImpl(), WebSudoManager.class);
            HashMap<Class, Object> publicContainer = new HashMap<Class, Object>();
            publicContainer.put(DescribedModuleDescriptorFactory.class, moduleDescriptorFactory);
            publicContainer.put(ListableModuleDescriptorFactory.class, moduleDescriptorFactory);
            publicContainer.put(ModuleDescriptorFactory.class, moduleDescriptorFactory);
            publicContainer.put(ModuleFactory.class, moduleFactory);
            publicContainer.put(ServletContextFactory.class, servletContextFactory);
            publicContainer.put(ServletModuleManager.class, this.servletModuleManager);
            this.hostContainer = new SimpleConstructorHostContainer(publicContainer);
            moduleFactory.addPrefixModuleFactory((PrefixModuleFactory)new ClassPrefixModuleFactory(this.hostContainer));
        }

        AtlassianPlugins getAlassianPlugins() {
            return this.plugins;
        }

        ServletModuleManager getServletModuleManager() {
            return this.servletModuleManager;
        }
    }
}

