/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportPackages {
    private final List<Jar> jars = new ArrayList<Jar>();
    private final Map<String, String> packages = new TreeMap<String, String>();
    private final Map<String, Jar> packageToJar = new HashMap<String, Jar>();
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(ExportPackages.class);
    private static final BundleRevision BUNDLE_REVISION = new MockBundleRevision();
    private static final String ANNOTATION_API = "javax.annotation";
    private static final String ANNOTATION_API_VERSION = "1.3.5";
    private static final String SERVLET_API = "javax.servlet";
    private static final String SERVLET_API_VERSION = "3.1.0";
    private static final String EL_API = "javax.el";
    private static final String EL_API_VERSION = "3.0.0";

    private ExportPackages(org.apache.felix.framework.Logger logger) {
        this.init(logger);
    }

    ExportPackages() {
    }

    public static ExportPackages create(org.apache.felix.framework.Logger logger) {
        return new ExportPackages(logger);
    }

    protected Manifest getManifest(URL url) {
        Manifest manifest = null;
        try (InputStream stream = url.openStream();){
            manifest = new Manifest(stream);
        }
        catch (Throwable exception) {
            log.warn("Failed to read manifest for {}: {}", new Object[]{url, exception.getMessage(), exception});
        }
        return manifest;
    }

    Map<String, String> getPackages() {
        return this.packages;
    }

    List<String> getPackageIncludes() {
        return new ArrayList<String>(this.packages.keySet());
    }

    List<String> getJarIncludes() {
        return this.includes;
    }

    List<String> getJarExcludes() {
        return this.excludes;
    }

    void init(Enumeration<URL> manifests, org.apache.felix.framework.Logger logger) {
        HashSet<String> seen = new HashSet<String>();
        List<URL> urls = this.getSortedUrls(manifests);
        for (URL url : urls) {
            String lowercaseURL = url.toString().toLowerCase();
            if (!seen.add(lowercaseURL)) continue;
            this.processManifest(url, logger);
        }
        this.determineIncludes();
        this.addAnnotationPackages();
        this.addELPackages();
        this.addServletPackages();
        if (log.isDebugEnabled()) {
            log.debug("Included jars: {}", (Object)StringUtils.join(this.includes, (String)","));
            log.debug("Excluded jars: {}", (Object)StringUtils.join(this.excludes, (String)","));
            log.debug("Packages: {}", (Object)this.packages.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ")));
        }
    }

    private List<URL> getSortedUrls(Enumeration<URL> urls) {
        ArrayList<URL> list = Collections.list(urls);
        list.sort(Comparator.comparing(URL::toString));
        return list;
    }

    private void determineIncludes() {
        TreeSet<String> include = new TreeSet<String>();
        TreeSet<String> exclude = new TreeSet<String>();
        for (Jar jar : this.jars) {
            if (jar.include) {
                include.add(jar.name);
                continue;
            }
            exclude.add(jar.name);
        }
        exclude.removeAll(include);
        this.includes.addAll(include);
        this.excludes.addAll(exclude);
    }

    private void init(org.apache.felix.framework.Logger logger) {
        Enumeration<URL> manifests;
        try {
            manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to get manifests to determine exports: " + exception.getMessage(), exception);
        }
        this.init(manifests, logger);
    }

    private void processManifest(URL manifestURL, org.apache.felix.framework.Logger logger) {
        Manifest manifest = this.getManifest(manifestURL);
        boolean include = false;
        Jar jar = this.addJar(manifestURL);
        if (jar != null && !this.excludeJar(jar)) {
            if (manifest != null) {
                Map<String, Object> attributes = this.getAttributes(manifest);
                if (attributes != null) {
                    if (this.addPackages(attributes, jar, logger)) {
                        include = true;
                    }
                } else {
                    include = this.includeNonOSGIJar(manifest);
                }
            }
            if (include || this.isAtlassianJar(jar) || this.isJavaEl(jar)) {
                jar.include = true;
            }
        }
    }

    private boolean isJavaEl(Jar jar) {
        return jar.name.equals("el-api.jar");
    }

    private boolean excludeJar(Jar jar) {
        return jar.name.startsWith("jsr305");
    }

    private boolean includeNonOSGIJar(Manifest manifest) {
        boolean include = false;
        Map<String, Attributes> entries = manifest.getEntries();
        if (entries.get("javax/annotation/") != null || entries.get("javax/el/") != null || entries.get("javax/servlet/") != null) {
            include = true;
        }
        return include;
    }

    private void addAnnotationPackages() {
        String version = this.packages.get(ANNOTATION_API);
        if (version == null) {
            log.info("javax.annotation not exported, defaulting version to 1.3.5");
            this.packages.put(ANNOTATION_API, ANNOTATION_API_VERSION);
            this.packages.put("javax.annotation.security", ANNOTATION_API_VERSION);
            this.packages.put("javax.annotation.sql", ANNOTATION_API_VERSION);
        }
    }

    private void addServletPackages() {
        String version = this.packages.get(SERVLET_API);
        if (version == null) {
            log.info("javax.servlet not exported, defaulting version to 3.1.0");
            this.packages.put(SERVLET_API, SERVLET_API_VERSION);
            this.packages.put("javax.servlet.annotation", SERVLET_API_VERSION);
            this.packages.put("javax.servlet.descriptor", SERVLET_API_VERSION);
            this.packages.put("javax.servlet.http", SERVLET_API_VERSION);
        }
    }

    private void addELPackages() {
        String version = this.packages.get(EL_API);
        if (version == null) {
            log.info("javax.el not exported, defaulting version to 3.0.0");
            this.packages.put(EL_API, EL_API_VERSION);
        }
    }

    private boolean isAtlassianJar(Jar jar) {
        return jar.name.startsWith("atlassian-") || jar.name.startsWith("velocity-htmlsafe");
    }

    private boolean exclude(String pkg) {
        return pkg.startsWith("org.osgi.") || pkg.startsWith("java.") || pkg.startsWith("javax.ws") || pkg.startsWith("com.fasterxml") || pkg.startsWith("org.openvpms.ws.util");
    }

    private Jar addJar(URL url) {
        String name;
        Jar jar = null;
        String path = url.getPath();
        int index = path.lastIndexOf(33);
        if (index > 0 && (index = (path = path.substring(0, index)).lastIndexOf(47)) >= 0 && !(name = path.substring(index + 1)).isEmpty()) {
            jar = new Jar(path, name);
            this.jars.add(jar);
        }
        return jar;
    }

    private boolean addPackages(Map<String, Object> manifest, Jar jar, org.apache.felix.framework.Logger logger) {
        HashMap<String, String> pkgVersions = new HashMap<String, String>();
        boolean exclude = false;
        try {
            Map configMap = Collections.emptyMap();
            ManifestParser parser = new ManifestParser(logger, configMap, BUNDLE_REVISION, manifest);
            for (BundleCapability capability : parser.getCapabilities()) {
                Map attributes;
                String pkg;
                if (!"osgi.wiring.package".equals(capability.getNamespace()) || (pkg = this.getString("osgi.wiring.package", attributes = capability.getAttributes())) == null) continue;
                if (this.exclude(pkg)) {
                    exclude = true;
                    break;
                }
                String version = this.getString("version", attributes);
                if (version == null) continue;
                this.addPackage(jar, pkg, version, pkgVersions);
            }
            if (!exclude) {
                this.packages.putAll(pkgVersions);
            }
        }
        catch (Throwable exception) {
            log.info("Failed to process {}: {}", new Object[]{jar.url, exception.getMessage(), exception});
        }
        return !exclude && !pkgVersions.isEmpty();
    }

    private void addPackage(Jar jar, String pkg, String version, Map<String, String> pkgVersions) {
        Jar existing = this.packageToJar.get(pkg);
        if (existing != null) {
            String existingVersion = this.packages.get(pkg);
            if (!version.equals(existingVersion)) {
                if (existingVersion == null) {
                    this.addPackageVersion(jar, pkg, version, pkgVersions);
                } else if (!existing.sameUrl(jar)) {
                    if (this.isGreater(version, existingVersion)) {
                        log.warn("Found newer version of package {} with version {} from '{}'. Replaces version {} from '{}'", new Object[]{pkg, version, jar.url, existingVersion, existing.url});
                        this.addPackageVersion(jar, pkg, version, pkgVersions);
                        existing.include = false;
                    } else {
                        log.warn("Excluding package {} with version {} from '{}'. Using version {} from '{}'", new Object[]{pkg, version, jar.url, existingVersion, existing.url});
                    }
                }
            } else if (!jar.sameUrl(existing)) {
                log.warn("Package {} occurs in both '{}' ({}) and '{}' ({})", new Object[]{pkg, existing.url, existingVersion, jar.url, version});
            }
        } else {
            this.addPackageVersion(jar, pkg, version, pkgVersions);
        }
    }

    private void addPackageVersion(Jar jar, String pkg, String version, Map<String, String> pkgVersions) {
        pkgVersions.put(pkg, version);
        this.packageToJar.put(pkg, jar);
    }

    private String getString(String name, Map<String, Object> attributes) {
        Object result = attributes.get(name);
        return result != null ? result.toString() : null;
    }

    private Map<String, Object> getAttributes(Manifest manifest) {
        StringMap result = null;
        if (manifest.getMainAttributes().getValue("Export-Package") != null) {
            result = new StringMap((Map)manifest.getMainAttributes());
        }
        return result;
    }

    private boolean isGreater(String version, String otherVersion) {
        try {
            Version a = new Version(version);
            Version b = new Version(otherVersion);
            return a.compareTo(b) > 0;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    private static class MockBundleRevision
    implements BundleRevision {
        private MockBundleRevision() {
        }

        public String getSymbolicName() {
            return null;
        }

        public Version getVersion() {
            return null;
        }

        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            return null;
        }

        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            return null;
        }

        public int getTypes() {
            return 0;
        }

        public BundleWiring getWiring() {
            return null;
        }

        public List<Capability> getCapabilities(String namespace) {
            return null;
        }

        public List<Requirement> getRequirements(String namespace) {
            return null;
        }

        public Bundle getBundle() {
            return null;
        }
    }

    private static class Jar {
        private final String url;
        private final String name;
        private boolean include = false;

        Jar(String url, String name) {
            this.url = url;
            this.name = name;
        }

        public boolean sameUrl(Jar other) {
            return this.url.equalsIgnoreCase(other.url);
        }
    }
}

