/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager;

import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.plugin.internal.manager.PluginManagerImpl;
import org.openvpms.plugin.internal.manager.ServletContainerContext;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.plugin.manager.PluginManagerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ConfigurablePluginManager
implements PluginManager,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private final HostComponentProvider provider;
    private final PluginDAO pluginDAO;
    private final ServletContainerContext context;
    private final PracticeService practiceService;
    private final Set<PluginManagerListener> listeners = Collections.synchronizedSet(new HashSet());
    private volatile PluginManager manager;
    private static final Logger log = LoggerFactory.getLogger(ConfigurablePluginManager.class);

    public ConfigurablePluginManager(HostComponentProvider provider, PluginDAO pluginDAO, ServletContainerContext context, PracticeService practiceService) {
        this.provider = provider;
        this.pluginDAO = pluginDAO;
        this.context = context;
        this.practiceService = practiceService;
    }

    public <T> boolean hasService(Class<T> type) {
        PluginManager current = this.manager;
        return current != null && current.hasService(type);
    }

    public <T> T getService(Class<T> type) {
        PluginManager current = this.manager;
        return (T)(current != null ? current.getService(type) : null);
    }

    public <T> List<T> getServices(Class<T> type) {
        PluginManager current = this.manager;
        return current != null ? current.getServices(type) : Collections.emptyList();
    }

    public BundleContext getBundleContext() {
        PluginManager current = this.manager;
        return current != null ? current.getBundleContext() : null;
    }

    public Bundle[] getBundles() {
        PluginManager current = this.manager;
        return current != null ? current.getBundles() : new Bundle[]{};
    }

    public boolean isStarted() {
        PluginManager current = this.manager;
        return current != null && current.isStarted();
    }

    public synchronized void start() {
        if (this.manager == null && this.practiceService.pluginsEnabled()) {
            this.manager = new PluginManagerImpl(this.provider, this.pluginDAO, this.context, this.practiceService);
            for (PluginManagerListener listener : this.listeners) {
                this.manager.addListener(listener);
            }
            this.manager.start();
        }
    }

    public synchronized void stop() {
        if (this.manager != null) {
            this.manager.stop();
            this.manager = null;
        }
    }

    public void install(File file) throws BundleException {
        PluginManager current = this.manager;
        if (current == null) {
            throw new BundleException("Plugin cannot be installed: PluginManager is not running", 2);
        }
        current.install(file);
    }

    public boolean canUninstall(Bundle bundle) {
        PluginManager current = this.manager;
        return current != null && current.canUninstall(bundle);
    }

    public void uninstall(Bundle bundle) throws BundleException {
        PluginManager current = this.manager;
        if (current == null) {
            throw new BundleException("Plugin cannot be uninstalled: PluginManager is not running", 2);
        }
        current.uninstall(bundle);
    }

    public boolean canRestart(Bundle bundle) {
        PluginManager current = this.manager;
        return current != null && current.canRestart(bundle);
    }

    public void start(Bundle bundle) {
        PluginManager current = this.manager;
        if (current == null) {
            throw new IllegalStateException("Plugin cannot be started: PluginManager is not running");
        }
        current.start(bundle);
    }

    public void stop(Bundle bundle) {
        PluginManager current = this.manager;
        if (current != null) {
            current.stop(bundle);
        }
    }

    public int scanForNewPlugins() {
        PluginManager current = this.manager;
        return current != null ? current.scanForNewPlugins() : 0;
    }

    public void addListener(PluginManagerListener listener) {
        this.listeners.add(listener);
        PluginManager current = this.manager;
        if (current != null) {
            current.addListener(listener);
        }
    }

    public void removeListener(PluginManagerListener listener) {
        this.listeners.remove(listener);
        PluginManager current = this.manager;
        if (current != null) {
            current.removeListener(listener);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            this.start();
        }
        catch (Throwable exception) {
            log.error("Failed to start the plugin manager", exception);
        }
    }

    public void destroy() throws Exception {
        try {
            this.stop();
        }
        finally {
            this.listeners.clear();
        }
    }
}

