/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.spring;

import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.hostcomponents.InstanceBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.openvpms.component.system.common.util.ClassHelper;
import org.springframework.beans.factory.BeanFactory;

public class SpringPluginServiceProvider
implements HostComponentProvider {
    private final BeanFactory factory;
    private final Map<String, List<String>> services;

    SpringPluginServiceProvider(BeanFactory factory, Map<String, List<String>> services) {
        this.factory = factory;
        this.services = services;
    }

    public void provide(ComponentRegistrar registrar) {
        for (Map.Entry<String, List<String>> entry : this.services.entrySet()) {
            List<Class> interfaces;
            String beanName = entry.getKey();
            if (!this.factory.isSingleton(beanName)) continue;
            Object bean = this.factory.getBean(beanName);
            List<String> interfaceNames = entry.getValue();
            if (!interfaceNames.isEmpty()) {
                interfaces = new ArrayList();
                for (String name : interfaceNames) {
                    Class type;
                    try {
                        type = ClassHelper.getClass((String)name);
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Class not found for plugin service=" + beanName + ": " + name, exception);
                    }
                    if (!type.isAssignableFrom(bean.getClass())) {
                        throw new IllegalStateException("Plugin service=" + beanName + " does not implement " + type);
                    }
                    interfaces.add(type);
                }
            } else {
                interfaces = ClassUtils.getAllInterfaces(bean.getClass());
            }
            if (interfaces.isEmpty()) continue;
            InstanceBuilder builder = registrar.register(interfaces.toArray(new Class[0]));
            builder.forInstance(bean);
        }
    }
}

