/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openvpms.plugin.internal.manager.spring.PluginServiceProviderConfig;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginServiceBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private static final String SERVICES = "services";

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext context) {
        this.addService(definition.getBeanName(), this.getInterfaces(node), context.getRegistry());
        return definition;
    }

    private List<String> getInterfaces(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node instanceof Element) {
            for (Element element : DomUtils.getChildElementsByTagName((Element)((Element)node), (String)"interface")) {
                String text = DomUtils.getTextValue((Element)element);
                if (StringUtils.isEmpty((Object)text)) continue;
                result.add(text);
            }
        }
        return result;
    }

    private void addService(String beanName, List<String> interfaces, BeanDefinitionRegistry registry) {
        HashMap<String, List<String>> services;
        BeanDefinition config = this.getConfig(registry);
        PropertyValue propertyValue = config.getPropertyValues().getPropertyValue(SERVICES);
        HashMap<String, List<String>> hashMap = services = propertyValue != null ? (HashMap<String, List<String>>)propertyValue.getValue() : null;
        if (services == null) {
            services = new HashMap<String, List<String>>();
            config.getPropertyValues().addPropertyValue(SERVICES, services);
        }
        services.put(beanName, interfaces);
    }

    private BeanDefinition getConfig(BeanDefinitionRegistry registry) {
        BeanDefinition config;
        if (!registry.containsBeanDefinition("_pluginServiceProviderConfig")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PluginServiceProviderConfig.class);
            config = builder.getBeanDefinition();
            registry.registerBeanDefinition("_pluginServiceProviderConfig", config);
        } else {
            config = registry.getBeanDefinition("_pluginServiceProviderConfig");
        }
        return config;
    }
}

