/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.atlassian;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.openvpms.plugin.internal.manager.ServletContainerContext;
import org.openvpms.version.Version;

public class WebResourceIntegrationImpl
implements WebResourceIntegration {
    private final PluginAccessor pluginAccessor;
    private final LocaleResolver localeResolver;
    private final PluginEventManager pluginEventManager;
    private final I18nResolver i18nResolver;
    private final ServletContainerContext servletContainerContext;
    private final I18nHasher i18nHasher;

    public WebResourceIntegrationImpl(PluginAccessor pluginAccessor, LocaleResolver localeResolver, I18nResolver i18nResolver, PluginEventManager pluginEventManager, ServletContainerContext servletContainerContext) {
        this.pluginAccessor = pluginAccessor;
        this.localeResolver = localeResolver;
        this.i18nResolver = i18nResolver;
        this.pluginEventManager = pluginEventManager;
        this.servletContainerContext = servletContainerContext;
        this.i18nHasher = new I18nHasher(pluginAccessor, pluginEventManager);
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public Map<String, Object> getRequestCache() {
        return this.servletContainerContext.getRequestCache();
    }

    public String getSystemCounter() {
        return "1";
    }

    public String getSystemBuildNumber() {
        return Version.REVISION;
    }

    public String getHostApplicationVersion() {
        return Version.VERSION;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        String result;
        HttpServletRequest request = this.servletContainerContext.getRequest();
        if (urlMode == UrlMode.ABSOLUTE && request != null) {
            StringBuffer url = request.getRequestURL();
            String uri = request.getRequestURI();
            String contextPath = request.getContextPath();
            result = url.substring(0, url.length() - uri.length() + contextPath.length());
        } else {
            result = this.servletContainerContext.getServletContext().getContextPath();
        }
        return result;
    }

    public String getSuperBatchVersion() {
        return "1";
    }

    public String getStaticResourceLocale() {
        return this.getLocale().toString();
    }

    public String getI18nStateHash() {
        return this.i18nHasher.get();
    }

    public File getTemporaryDirectory() {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir);
    }

    public CDNStrategy getCDNStrategy() {
        return null;
    }

    public Locale getLocale() {
        return this.servletContainerContext.getLocale();
    }

    public Iterable<Locale> getSupportedLocales() {
        return Collections.singletonList(Locale.getDefault());
    }

    public String getI18nRawText(Locale locale, String key) {
        return this.i18nResolver.getRawText(locale, key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nResolver.getText(locale, key);
    }

    public Set<String> allowedCondition1Keys() {
        return Collections.emptySet();
    }

    public Set<String> allowedTransform1Keys() {
        return Collections.emptySet();
    }

    public static class I18nHasher {
        private final ResettableLazyReference<String> hashLazyReference;

        I18nHasher(final PluginAccessor pluginAccessor, PluginEventManager eventManager) {
            this.hashLazyReference = new ResettableLazyReference<String>(){

                protected String create() throws Exception {
                    TreeSet<String> versions = new TreeSet<String>();
                    for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
                        versions.add(plugin.getKey() + " v. " + plugin.getPluginInformation().getVersion());
                    }
                    return "" + versions.hashCode();
                }
            };
            eventManager.register((Object)this);
        }

        public String get() {
            return (String)this.hashLazyReference.get();
        }

        @PluginEventListener
        public void onPluginDisabled(PluginDisabledEvent event) {
            this.hashLazyReference.reset();
        }

        @PluginEventListener
        public void onPluginEnabled(PluginEnabledEvent event) {
            this.hashLazyReference.reset();
        }

        @PluginEventListener
        public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
            this.hashLazyReference.reset();
        }

        @PluginEventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
            this.hashLazyReference.reset();
        }
    }
}

