/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginRegistry;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.atlassian.plugin.main.HotDeployer;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginRegistryImpl;
import com.atlassian.plugin.manager.ProductPluginAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.plugin.internal.manager.persistence.PluginInstallerImpl;
import org.openvpms.plugin.internal.manager.persistence.PluginScannerImpl;

public class AtlassianPlugins {
    public static final String TEMP_DIRECTORY_SUFFIX = ".tmp";
    private final OsgiContainerManager osgiContainerManager;
    private final DefaultPluginEventManager pluginEventManager;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final SplitStartupPluginSystemLifecycle pluginSystemLifecycle;
    private final EventPublisher eventPublisher;
    private HotDeployer hotDeployer;

    public AtlassianPlugins(PluginsConfiguration config, PluginDAO pluginDAO) {
        this.pluginEventManager = new DefaultPluginEventManager(config.getScopeManager());
        this.eventPublisher = this.pluginEventManager.getEventPublisher();
        AtomicReference<PluginAccessor> pluginAccessorRef = new AtomicReference<PluginAccessor>();
        this.osgiContainerManager = new FelixOsgiContainerManager(config.getFrameworkBundleDirectory(), config.getOsgiPersistentCache(), config.getPackageScannerConfiguration(), (HostComponentProvider)new CriticalHostComponentProvider(config.getHostComponentProvider(), (PluginEventManager)this.pluginEventManager, pluginAccessorRef), (PluginEventManager)this.pluginEventManager);
        HashSet applications = config.getApplication() != null ? Sets.newHashSet((Object[])new Application[]{config.getApplication()}) : Collections.emptySet();
        OsgiPluginFactory osgiPluginDeployer = new OsgiPluginFactory(config.getPluginDescriptorFilename(), (Set)applications, config.getOsgiPersistentCache(), this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        OsgiBundleFactory osgiBundleDeployer = new OsgiBundleFactory(this.osgiContainerManager);
        RemotablePluginFactory remotablePluginFactory = new RemotablePluginFactory(config.getPluginDescriptorFilename(), (Set)applications, this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        LinkedList<AbstractPluginFactory> pluginDeployers = new LinkedList<AbstractPluginFactory>(Arrays.asList(osgiPluginDeployer, osgiBundleDeployer, remotablePluginFactory));
        if (config.isUseLegacyDynamicPluginDeployer()) {
            pluginDeployers.add((AbstractPluginFactory)new LegacyDynamicPluginFactory(config.getPluginDescriptorFilename()));
        }
        ArrayList<Object> pluginLoaders = new ArrayList<Object>();
        pluginLoaders.add(new ClassPathPluginLoader());
        if (config.getBundledPluginUrl() != null) {
            pluginLoaders.add(new BundledPluginLoader(config.getBundledPluginUrl(), config.getBundledPluginCacheDirectory(), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        }
        pluginLoaders.add(new ScanningPluginLoader((Scanner)new PluginScannerImpl(config.getPluginDirectory(), pluginDAO), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        PluginRegistryImpl pluginRegistry = new PluginRegistryImpl();
        this.pluginAccessor = new ProductPluginAccessor((PluginRegistry.ReadOnly)pluginRegistry, config.getPluginStateStore(), config.getModuleDescriptorFactory(), (PluginEventManager)this.pluginEventManager, config.getScopeManager());
        DefaultPluginManager defaultPluginManager = DefaultPluginManager.newBuilder().withPluginRegistry((PluginRegistry.ReadWrite)pluginRegistry).withStore(config.getPluginStateStore()).withPluginLoaders(pluginLoaders).withModuleDescriptorFactory(config.getModuleDescriptorFactory()).withPluginEventManager((PluginEventManager)this.pluginEventManager).withPluginAccessor(this.pluginAccessor).build();
        this.pluginController = defaultPluginManager;
        this.pluginSystemLifecycle = defaultPluginManager;
        pluginAccessorRef.set(this.pluginAccessor);
        defaultPluginManager.setPluginInstaller((PluginInstaller)new PluginInstallerImpl(pluginDAO));
        if (config.getHotDeployPollingPeriod() > 0L) {
            this.hotDeployer = new HotDeployer(this.pluginController, config.getHotDeployPollingPeriod());
        }
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public PluginController getPluginController() {
        return this.pluginController;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public SplitStartupPluginSystemLifecycle getPluginSystemLifecycle() {
        return this.pluginSystemLifecycle;
    }

    @PluginEventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        if (this.hotDeployer != null && !this.hotDeployer.isRunning()) {
            this.hotDeployer.start();
        }
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        if (this.hotDeployer != null && this.hotDeployer.isRunning()) {
            this.hotDeployer.stop();
        }
    }

    private static class CriticalHostComponentProvider
    implements HostComponentProvider {
        private final HostComponentProvider delegate;
        private final PluginEventManager pluginEventManager;
        private final AtomicReference<PluginAccessor> pluginManagerRef;

        CriticalHostComponentProvider(HostComponentProvider delegate, PluginEventManager pluginEventManager, AtomicReference<PluginAccessor> pluginManagerRef) {
            this.delegate = delegate;
            this.pluginEventManager = pluginEventManager;
            this.pluginManagerRef = pluginManagerRef;
        }

        public void provide(ComponentRegistrar registrar) {
            registrar.register(new Class[]{PluginEventManager.class}).forInstance((Object)this.pluginEventManager);
            registrar.register(new Class[]{PluginAccessor.class}).forInstance((Object)this.pluginManagerRef.get());
            this.delegate.provide(registrar);
        }
    }
}

