/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.atlassian.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ServletContextThreadLocal {
    private static final ThreadLocal<Context> context = new ThreadLocal();

    ServletContextThreadLocal() {
    }

    static HttpServletRequest getRequest() {
        Context result = context.get();
        return result != null ? result.request : null;
    }

    static HttpServletResponse getResponse() {
        Context result = context.get();
        return result != null ? result.response : null;
    }

    static Map<String, Object> getRequestCache() {
        Context result = context.get();
        return result != null ? result.requestCache : null;
    }

    static void setContext(HttpServletRequest request, HttpServletResponse response) {
        context.set(new Context(request, response));
    }

    static void clearContext() {
        context.remove();
    }

    private static class Context {
        final HttpServletRequest request;
        final HttpServletResponse response;
        final Map<String, Object> requestCache;

        public Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.requestCache = new HashMap<String, Object>();
        }
    }
}

