/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.persistence;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.component.business.domain.im.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginScannerImpl
implements Scanner {
    private final File dir;
    private final PluginDAO dao;
    private final Map<DeploymentUnit, Long> deploymentUnits = new HashMap<DeploymentUnit, Long>();
    private final Map<Long, Long> pluginVersions = new HashMap<Long, Long>();
    private static final Logger log = LoggerFactory.getLogger(PluginScannerImpl.class);

    public PluginScannerImpl(File dir, PluginDAO dao) {
        this.dir = dir;
        this.dao = dao;
    }

    public synchronized Collection<DeploymentUnit> scan() {
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>();
        Iterator iterator = this.dao.getPlugins();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            Long version = this.pluginVersions.get(plugin.getId());
            if (version != null && version.longValue() == plugin.getVersion()) continue;
            DeploymentUnit unit = this.deploy(plugin);
            result.add(unit);
        }
        return result;
    }

    public synchronized Collection<DeploymentUnit> getDeploymentUnits() {
        return this.deploymentUnits.keySet();
    }

    public synchronized void reset() {
        this.deploymentUnits.clear();
        this.pluginVersions.clear();
        try {
            FileUtils.deleteDirectory((File)this.dir);
            if (!this.dir.mkdirs()) {
                log.error("Failed to create directory=" + this.dir);
            }
        }
        catch (IOException exception) {
            log.error("Failed to delete directory=" + this.dir + ": " + exception.getMessage(), (Throwable)exception);
        }
    }

    public synchronized void remove(DeploymentUnit unit) {
        Long id = this.deploymentUnits.get(unit);
        if (id == null) {
            throw new PluginException("Deployment unit not found: " + unit);
        }
        this.deploymentUnits.remove(unit);
        this.pluginVersions.remove(id);
        if (!unit.getPath().delete()) {
            throw new PluginException("Failed to remove deployment unit: " + unit);
        }
    }

    private DeploymentUnit deploy(Plugin plugin) {
        InputStream binary = this.dao.getBinary(plugin.getKey());
        File file = new File(this.dir, plugin.getVersion() + "-" + plugin.getName());
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtils.copy((InputStream)binary, (OutputStream)out);
        }
        catch (IOException exception) {
            throw new PluginException("Failed to write plugin to " + file + ": " + exception.getMessage(), (Throwable)exception);
        }
        Date modified = plugin.getUpdated();
        if (modified == null) {
            modified = plugin.getCreated();
        }
        if (modified == null || !file.setLastModified(modified.getTime())) {
            log.warn("Failed to set modified timestamp for " + file);
        }
        DeploymentUnit unit = new DeploymentUnit(file);
        this.deploymentUnits.put(unit, plugin.getId());
        this.pluginVersions.put(plugin.getId(), plugin.getVersion());
        return unit;
    }
}

