/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.persistence;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInstaller;
import java.io.IOException;
import java.io.InputStream;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInstallerImpl
implements PluginInstaller {
    private final PluginDAO dao;
    private static final Logger log = LoggerFactory.getLogger(PluginInstallerImpl.class);

    public PluginInstallerImpl(PluginDAO dao) {
        this.dao = dao;
    }

    public void installPlugin(String key, PluginArtifact pluginArtifact) {
        try (InputStream stream = pluginArtifact.getInputStream();){
            this.dao.save(key, pluginArtifact.getName(), stream);
        }
        catch (IOException exception) {
            log.error("Failed to close stream for " + pluginArtifact.getName() + ": " + exception.getMessage(), (Throwable)exception);
        }
    }
}

