/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.atlassian;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserResolutionException;
import com.atlassian.seraph.auth.AuthenticationContext;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.security.UserService;
import org.openvpms.component.model.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserManagerImpl
implements UserManager {
    private final UserService service;
    private final AuthenticationContext authenticationContext;
    private final UserRules userRules;
    private final AuthenticationManager authenticationManager;
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);

    public UserManagerImpl(UserService service, AuthenticationContext authenticationContext, UserRules userRules, AuthenticationManager authenticationManager) {
        this.service = service;
        this.authenticationContext = authenticationContext;
        this.userRules = userRules;
        this.authenticationManager = authenticationManager;
    }

    public String getRemoteUsername() {
        Principal user = this.authenticationContext.getUser();
        return user != null ? user.getName() : null;
    }

    public UserProfile getRemoteUser() {
        Principal principal = this.authenticationContext.getUser();
        return principal != null ? this.getUserProfile(principal.getName()) : null;
    }

    public UserKey getRemoteUserKey() {
        Principal principal = this.authenticationContext.getUser();
        return principal != null ? new UserKey(principal.getName()) : null;
    }

    public String getRemoteUsername(HttpServletRequest request) {
        return request.getRemoteUser();
    }

    public UserProfile getRemoteUser(HttpServletRequest request) {
        return this.getUserProfile(request.getRemoteUser());
    }

    public UserKey getRemoteUserKey(HttpServletRequest request) {
        String username = request.getRemoteUser();
        return username != null ? new UserKey(username) : null;
    }

    public UserProfile getUserProfile(String username) {
        org.openvpms.component.business.domain.im.security.User user = this.getUser(username);
        return user != null ? new UserProfileImpl(user) : null;
    }

    public UserProfile getUserProfile(UserKey userKey) {
        return userKey != null ? this.getUserProfile(userKey.getStringValue()) : null;
    }

    public boolean isUserInGroup(String username, String group) {
        return false;
    }

    public boolean isUserInGroup(UserKey userKey, String group) {
        return false;
    }

    public boolean isSystemAdmin(String userName) {
        return this.isAdministrator(userName);
    }

    public boolean isSystemAdmin(UserKey userKey) {
        return userKey != null && this.isSystemAdmin(userKey.getStringValue());
    }

    public boolean isAdmin(String username) {
        return this.isSystemAdmin(username);
    }

    public boolean isAdmin(UserKey userKey) {
        return this.isSystemAdmin(userKey);
    }

    public boolean authenticate(String username, String password) {
        boolean result = false;
        try {
            Authentication authenticate = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            result = authenticate != null;
        }
        catch (Throwable exception) {
            log.debug("Failed to authenticate " + username, exception);
        }
        return result;
    }

    public Principal resolve(String username) throws UserResolutionException {
        Principal principal = null;
        try {
            if (this.getUser(username) != null) {
                principal = () -> username;
            }
        }
        catch (Throwable exception) {
            throw new UserResolutionException("Failed to resolve user: " + username, exception);
        }
        return principal;
    }

    public Iterable<String> findGroupNamesByPrefix(String s, int i, int i1) {
        return null;
    }

    private boolean isAdministrator(String userName) {
        org.openvpms.component.business.domain.im.security.User user = this.getUser(userName);
        return user != null && this.userRules.isAdministrator((User)user);
    }

    private org.openvpms.component.business.domain.im.security.User getUser(String username) {
        org.openvpms.component.business.domain.im.security.User result = null;
        if (username != null) {
            try {
                result = (org.openvpms.component.business.domain.im.security.User)this.service.loadUserByUsername(username);
            }
            catch (UsernameNotFoundException exception) {
                log.debug(exception.getMessage(), (Throwable)exception);
            }
            catch (Throwable exception) {
                log.warn("Failed to retrieve user: " + username, exception);
            }
        }
        return result;
    }

    private static class UserProfileImpl
    implements UserProfile,
    UserDetails {
        private final org.openvpms.component.business.domain.im.security.User user;

        UserProfileImpl(org.openvpms.component.business.domain.im.security.User user) {
            this.user = user;
        }

        public UserKey getUserKey() {
            return new UserKey(this.user.getUsername());
        }

        public String getUsername() {
            return this.user.getUsername();
        }

        public String getFullName() {
            return this.user.getName();
        }

        public String getEmail() {
            return null;
        }

        public URI getProfilePictureUri(int i, int i1) {
            return null;
        }

        public URI getProfilePictureUri() {
            return null;
        }

        public URI getProfilePageUri() {
            return null;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.user.getAuthorities();
        }

        public String getPassword() {
            return this.user.getPassword();
        }

        public boolean isAccountNonExpired() {
            return this.user.isAccountNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.user.isAccountNonLocked();
        }

        public boolean isCredentialsNonExpired() {
            return this.user.isCredentialsNonExpired();
        }

        public boolean isEnabled() {
            return this.user.isEnabled();
        }
    }
}

