/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.internal.manager.atlassian;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.message.MessageCollection;
import com.atlassian.sal.core.message.AbstractI18nResolver;
import com.atlassian.sal.core.message.DefaultMessage;
import com.atlassian.sal.core.message.DefaultMessageCollection;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class I18nResolverImpl
extends AbstractI18nResolver {
    private final Map<Plugin, Iterable<String>> pluginResourceBundleNames = new ConcurrentHashMap<Plugin, Iterable<String>>();
    private ManagedLock.ReadWrite locks = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());
    private static final Serializable[] EMPTY_SERIALIZABLE = new Serializable[0];

    public I18nResolverImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        pluginEventManager.register((Object)this);
        this.locks.write().withLock(() -> this.addPluginResourceBundles(pluginAccessor.getPlugins()));
    }

    public String resolveText(String key, Serializable[] arguments) {
        String pattern = this.getPattern(Locale.getDefault(), key);
        if (pattern == null) {
            return key;
        }
        return MessageFormat.format(pattern, arguments);
    }

    public String resolveText(Locale locale, String key, Serializable[] arguments) {
        String pattern = StringUtils.defaultString((String)this.getPattern(locale, key), (String)this.getPattern(Locale.getDefault(), key));
        if (pattern == null) {
            return key;
        }
        return MessageFormat.format(pattern, arguments);
    }

    public String getRawText(String key) {
        return StringUtils.defaultString((String)this.getPattern(Locale.getDefault(), key), (String)key);
    }

    public String getRawText(Locale locale, String key) {
        return StringUtils.defaultString((String)this.getPattern(locale, key), (String)key);
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        return (Map)this.locks.read().withLock(() -> {
            HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
            for (Map.Entry<Plugin, Iterable<String>> pluginBundleNames : this.pluginResourceBundleNames.entrySet()) {
                this.addMatchingTranslationsToMap(prefix, Locale.getDefault(), pluginBundleNames.getKey(), pluginBundleNames.getValue(), translationsWithPrefix);
            }
            return translationsWithPrefix;
        });
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        Objects.requireNonNull(prefix, "prefix");
        Objects.requireNonNull(locale, "locale");
        return (Map)this.locks.read().withLock(() -> {
            HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
            for (Map.Entry<Plugin, Iterable<String>> pluginBundleNames : this.pluginResourceBundleNames.entrySet()) {
                this.addMatchingTranslationsToMap(prefix, locale, pluginBundleNames.getKey(), pluginBundleNames.getValue(), translationsWithPrefix);
            }
            return translationsWithPrefix;
        });
    }

    public String getText(String key, Serializable ... arguments) {
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText((Message)argument) : arguments[i];
        }
        return this.resolveText(key, resolvedArguments);
    }

    public String getText(Locale locale, String key, Serializable ... arguments) {
        Objects.requireNonNull(locale, "locale");
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText(locale, (Message)argument) : arguments[i];
        }
        return this.resolveText(locale, key, resolvedArguments);
    }

    public String getText(String key) {
        return this.resolveText(key, EMPTY_SERIALIZABLE);
    }

    public String getText(Locale locale, String key) {
        Objects.requireNonNull(locale, "locale");
        return this.resolveText(locale, key, EMPTY_SERIALIZABLE);
    }

    public String getText(Message message) {
        return this.getText(message.getKey(), message.getArguments());
    }

    public String getText(Locale locale, Message message) {
        return this.getText(locale, message.getKey(), message.getArguments());
    }

    public Message createMessage(String key, Serializable ... arguments) {
        return new DefaultMessage(key, arguments);
    }

    public MessageCollection createMessageCollection() {
        return new DefaultMessageCollection();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.locks.write().withLock(() -> this.addPluginResourceBundles(event.getPlugin()));
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.locks.write().withLock(() -> this.removePluginResourceBundles(event.getPlugin()));
    }

    private String getPattern(Locale locale, String key) {
        return (String)this.locks.read().withLock(() -> {
            String bundleString = null;
            for (Map.Entry<Plugin, Iterable<String>> pluginBundleNames : this.pluginResourceBundleNames.entrySet()) {
                for (String bundleName : pluginBundleNames.getValue()) {
                    try {
                        ResourceBundle bundle = this.getBundle(bundleName, locale, pluginBundleNames.getKey());
                        bundleString = bundle.getString(key);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            }
            return bundleString;
        });
    }

    private void addMatchingTranslationsToMap(String prefix, Locale locale, Plugin plugin, Iterable<String> bundleNames, Map<String, String> translationsWithPrefix) {
        for (String bundleName : bundleNames) {
            try {
                ResourceBundle bundle = this.getBundle(bundleName, locale, plugin);
                if (bundle == null) continue;
                this.addMatchingTranslationsToMap(prefix, bundle, translationsWithPrefix);
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    private void addMatchingTranslationsToMap(String prefix, ResourceBundle bundle, Map<String, String> translationsWithPrefix) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            translationsWithPrefix.put(key, bundle.getString(key));
        }
    }

    private void addPluginResourceBundles(Iterable<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.addPluginResourceBundles(plugin);
        }
    }

    private void addPluginResourceBundles(Plugin plugin) {
        List<String> bundleNames = plugin.getResourceDescriptors().stream().filter(descriptor -> "i18n".equals(descriptor.getType())).map(ResourceDescriptor::getLocation).collect(Collectors.toList());
        this.addPluginResourceBundles(plugin, bundleNames);
    }

    private void addPluginResourceBundles(Plugin plugin, List<String> bundleNames) {
        this.pluginResourceBundleNames.put(plugin, bundleNames);
    }

    private void removePluginResourceBundles(Plugin plugin) {
        this.pluginResourceBundleNames.remove(plugin);
    }

    private ResourceBundle getBundle(String bundleName, Locale locale, Plugin plugin) {
        return ResourceBundle.getBundle(bundleName, locale, plugin.getClassLoader());
    }
}

