/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.plugin.auth.internal;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import java.security.Principal;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatorImpl
extends DefaultAuthenticator {
    private final UserManager userManager;

    public AuthenticatorImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    protected Principal getUser(String username) {
        UsernamePasswordAuthenticationToken result = null;
        UserProfile profile = this.userManager.getUserProfile(username);
        if (profile instanceof UserDetails) {
            UserDetails details = (UserDetails)profile;
            result = new UsernamePasswordAuthenticationToken((Object)details, null, details.getAuthorities());
        }
        return result;
    }

    protected boolean authenticate(Principal user, String password) throws AuthenticatorException {
        return this.userManager.authenticate(user.getName(), password);
    }
}

