/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.workflow.osworkflow.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.bind.RequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springmodules.workflow.osworkflow.OsWorkflowContext;
import org.springmodules.workflow.osworkflow.OsWorkflowContextHolder;

public abstract class AbstractWorkflowContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    public static final String SESSION_KEY_INSTANCE_ID = "org.springmodules.workflow.osworkflow.instanceId";
    private static final String DEFAULT_OVERRIDE_REQUEST_PARAMETER = "instanceId";
    private boolean sessionStorageEnabled = true;
    private boolean allowOverrideWithRequestParameter = true;
    private String overrideRequestParameterKey = "instanceId";

    public void setSessionStorageEnabled(boolean sessionStorageEnabled) {
        this.sessionStorageEnabled = sessionStorageEnabled;
    }

    public void setAllowOverrideWithRequestParameter(boolean allowOverrideWithRequestParameter) {
        this.allowOverrideWithRequestParameter = allowOverrideWithRequestParameter;
    }

    public void setOverrideRequestParameterKey(String overrideRequestParameterKey) {
        this.overrideRequestParameterKey = overrideRequestParameterKey;
    }

    protected boolean isSessionStorageEnabled() {
        return this.sessionStorageEnabled;
    }

    protected boolean isAllowOverrideWithRequestParameter() {
        return this.allowOverrideWithRequestParameter;
    }

    protected String getOverrideRequestParameterKey() {
        return this.overrideRequestParameterKey;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        OsWorkflowContext context = OsWorkflowContextHolder.getWorkflowContext();
        context.setCaller(this.getCaller(request));
        if (this.isAllowOverrideWithRequestParameter()) {
            HttpSession session;
            Object instanceId;
            long instanceIdFromRequest = RequestUtils.getLongParameter((HttpServletRequest)request, (String)this.getOverrideRequestParameterKey(), (long)Long.MIN_VALUE);
            if (instanceIdFromRequest != Long.MIN_VALUE) {
                System.out.println("Setting instance id");
                context.setInstanceId(instanceIdFromRequest);
            } else if (this.isSessionStorageEnabled() && (instanceId = (session = request.getSession()).getAttribute(SESSION_KEY_INSTANCE_ID)) != null && instanceId instanceof Long) {
                context.setInstanceId((Long)instanceId);
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        OsWorkflowContext context = OsWorkflowContextHolder.getWorkflowContext();
        if (this.isSessionStorageEnabled() && context.hasInstanceId()) {
            HttpSession session = request.getSession();
            session.setAttribute(SESSION_KEY_INSTANCE_ID, (Object)new Long(context.getInstanceId()));
        }
    }

    protected abstract String getCaller(HttpServletRequest var1);
}

