/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.hivemind;

import org.apache.hivemind.Registry;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.Assert;

public class ServiceFactoryBean
implements FactoryBean,
InitializingBean {
    private Registry registry;
    private String serviceName;
    private Class serviceInterface;
    static /* synthetic */ Class class$org$springmodules$hivemind$ServiceFactoryBean;

    public void setServiceInterface(Class serviceInterface) {
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"Cannot use a Class for the service interface");
        this.serviceInterface = serviceInterface;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Object getObject() throws Exception {
        return this.getServiceObject();
    }

    public Class getObjectType() {
        return this.getServiceObject().getClass();
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.registry == null) {
            throw new ApplicationContextException("Property [registry] of class [" + (class$org$springmodules$hivemind$ServiceFactoryBean == null ? (class$org$springmodules$hivemind$ServiceFactoryBean = ServiceFactoryBean.class$("org.springmodules.hivemind.ServiceFactoryBean")) : class$org$springmodules$hivemind$ServiceFactoryBean) + "] is required.");
        }
        if (this.serviceInterface == null) {
            throw new ApplicationContextException("Property [serviceInterface] of class [" + (class$org$springmodules$hivemind$ServiceFactoryBean == null ? (class$org$springmodules$hivemind$ServiceFactoryBean = ServiceFactoryBean.class$("org.springmodules.hivemind.ServiceFactoryBean")) : class$org$springmodules$hivemind$ServiceFactoryBean) + "] is required.");
        }
        boolean containsService = false;
        containsService = this.serviceName == null ? this.registry.containsService(this.serviceInterface) : this.registry.containsService(this.serviceName, this.serviceInterface);
        if (!containsService) {
            throw new ApplicationContextException("Service with interface [" + this.serviceInterface.getName() + "] and name [" + this.serviceName + "] is not present in registry.");
        }
    }

    private Object getServiceObject() {
        if (this.serviceName == null) {
            return this.registry.getService(this.serviceInterface);
        }
        return this.registry.getService(this.serviceName, this.serviceInterface);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

